/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rectangle {
    private Point topLeft;
    private int width;
    private int height;

    public Rectangle() {
        this(new Point(), 0, 0);
    }

    public Rectangle(Point topLeft, int width, int height) {
        this.topLeft = topLeft;
        this.width = width;
        this.height = height;
    }

    public void move(int x, int y) {
        this.topLeft.move(x, y);
    }

    public void setLocation(int x, int y) {
        this.topLeft.setLocation(x, y);
    }

    public void centerOn(int x, int y) {
        this.topLeft.setLocation(x - this.width / 2, y - this.height / 2);
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Point getCenter() {
        int x = this.topLeft.getX() + this.width / 2;
        int y = this.topLeft.getY() + this.height / 2;
        return new Point(x, y);
    }

    public boolean contains(Point p) {
        Point bottomRight = new Point(this.topLeft.getX() + this.width, this.topLeft.getY() + this.height);
        return p.getX() >= this.topLeft.getX() && p.getX() <= bottomRight.getX() && p.getY() >= this.topLeft.getY() && p.getY() <= bottomRight.getY();
    }

    public boolean containsAny(Point ... points) {
        return this.containsAny(Arrays.asList(points));
    }

    public boolean containsAny(List<Point> points) {
        for (Point p : points) {
            if (!this.contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Point ... points) {
        return this.containsAll(Arrays.asList(points));
    }

    public boolean containsAll(List<Point> points) {
        for (Point p : points) {
            if (this.contains(p)) continue;
            return false;
        }
        return true;
    }
}

