/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.controller.TilingController;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModel;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModelListener;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util.Point;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.util.Rectangle;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.view.i18n.TranslationConstants;

public class TilingPreviewPanel
extends Composite
implements TilingModelListener {
    private static final String DEFAULT_CLASS_NAME = "tilingPreviewPanel";
    private AbsolutePanel tilingViewPanel;
    private AbsolutePanel tilingView;
    private final TilingController controller;
    private final TilingModel model;
    private final Map<String, Image> images = new HashMap<String, Image>();

    public TilingPreviewPanel(TilingController tilingController, TilingModel tilingModel) {
        this.controller = tilingController;
        this.model = tilingModel;
        this.model.addListener(this);
        this.tilingViewPanel = new AbsolutePanel();
        this.tilingViewPanel.setPixelSize(this.model.getViewAreaWidth(), this.model.getViewAreaHeight());
        this.tilingView = new AbsolutePanel();
        this.tilingViewPanel.add((Widget)this.tilingView);
        this.tilingViewPanel.addStyleName("tilingViewPanel");
        AbsolutePanel rootPanel = new AbsolutePanel();
        rootPanel.setPixelSize(this.model.getViewAreaWidth(), this.model.getViewAreaHeight());
        rootPanel.addStyleName("tilingMasterContainer");
        rootPanel.add((Widget)this.tilingViewPanel, 0, 0);
        HorizontalPanel hPanel = this.createZoomButtons();
        rootPanel.add((Widget)hPanel, 20, 20);
        this.initWidget((Widget)rootPanel);
        this.setStyleName(DEFAULT_CLASS_NAME);
    }

    private HorizontalPanel createZoomButtons() {
        HorizontalPanel buttons = new HorizontalPanel();
        TranslationConstants translationContants = (TranslationConstants)GWT.create(TranslationConstants.class);
        Button resetZoomButton = new Button();
        resetZoomButton.addClickListener(new ClickListener(){

            public void onClick(Widget arg0) {
                Window.Location.assign((String)Window.Location.getHref());
                TilingPreviewPanel.this.decorate();
            }
        });
        resetZoomButton.addStyleName("resetZoomButton");
        resetZoomButton.setTitle(translationContants.zoom());
        buttons.add((Widget)resetZoomButton);
        Button zoomInButton = new Button();
        zoomInButton.addClickListener(new ClickListener(){

            public void onClick(Widget arg0) {
                TilingPreviewPanel.this.model.zoomIn();
            }
        });
        zoomInButton.addStyleName("zoomInButton");
        zoomInButton.setTitle(translationContants.zoomIn());
        buttons.add((Widget)zoomInButton);
        Button zoomOutButton = new Button();
        zoomOutButton.addClickListener(new ClickListener(){

            public void onClick(Widget arg0) {
                TilingPreviewPanel.this.model.zoomOut();
            }
        });
        zoomOutButton.addStyleName("zoomOutButton");
        zoomOutButton.setTitle(translationContants.zoomOut());
        buttons.add((Widget)zoomOutButton);
        return buttons;
    }

    public void onModelChange(TilingModel.TilingModelEvent event, TilingModel model) {
        switch (event) {
            case MOVE_EVENT: {
                this.renderView();
                break;
            }
            case TILING_INFO_UPDATED: {
                this.resetView();
                this.renderView();
            }
        }
    }

    private void renderView() {
        int widthInTiles = this.model.getWidthInTiles();
        int heightInTiles = this.model.getHeightInTiles();
        int top = this.model.getViewAreaTop();
        int left = this.model.getViewAreaLeft();
        int width = this.model.getViewAreaWidth();
        int height = this.model.getViewAreaHeight();
        Rectangle viewableArea = new Rectangle(new Point(left, top), width, height);
        this.tilingView.clear();
        for (int y = 0; y < heightInTiles; ++y) {
            for (int x = 0; x < widthInTiles; ++x) {
                Point imageBottomRight;
                Point imageTopRight;
                String imageUrl = this.model.getBaseUrl() + "?x=" + x + "&y=" + y;
                imageUrl = imageUrl + "&date=" + this.model.getLastModificationDate();
                int imageLeft = x * this.model.getTileWidth();
                int imageTop = y * this.model.getTileHeight();
                int imageRight = imageLeft + this.model.getTileWidth();
                Point imageTopLeft = new Point(imageLeft, imageTop);
                int imageBottom = imageTop + this.model.getTileHeight();
                Point imageBottomLeft = new Point(imageLeft, imageBottom);
                if (!viewableArea.containsAny(imageTopLeft, imageBottomLeft, imageTopRight = new Point(imageRight, imageTop), imageBottomRight = new Point(imageRight, imageBottom)) && (x != 0 || y != 0)) continue;
                Log.debug((String)("Getting image: " + imageUrl));
                Image image = this.getImage(imageUrl);
                if (x == 0 && y == 0) {
                    image.getElement().setId("annotationRootImage");
                }
                this.tilingView.add((Widget)image, imageLeft, imageTop);
            }
        }
        this.tilingViewPanel.add((Widget)this.tilingView, -left, -top);
        this.decorate();
    }

    private Image getImage(String imageUrl) {
        Image image = this.images.get(imageUrl);
        if (image == null) {
            image = new Image(imageUrl);
            this.images.put(imageUrl, image);
        }
        return image;
    }

    private void decorate() {
        try {
            this.controller.updateAnnotationDecoration();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetView() {
        this.images.clear();
        this.tilingView.clear();
        this.tilingView.setPixelSize(this.model.getTotalWidth(), this.model.getTotalHeight());
    }
}

