/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.defaultPermissions;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.platform.defaultPermissions.ConfigurationDescriptor;
import org.nuxeo.ecm.platform.defaultPermissions.DocumentDescriptor;
import org.nuxeo.ecm.platform.defaultPermissions.PermissionDescriptor;
import org.nuxeo.ecm.platform.defaultPermissions.PrincipalDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class DefaultPermissionService
extends DefaultComponent {
    public static final String ID = DefaultPermissionService.class.getCanonicalName();
    private static final Log log = LogFactory.getLog(DefaultPermissionService.class);
    private final Map<String, ACL> defaultPermissions = new HashMap<String, ACL>();

    public void activate(ComponentContext context) throws Exception {
        log.debug((Object)"<activate>");
        super.activate(context);
        this.defaultPermissions.clear();
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.debug((Object)"<deactivate>");
        super.deactivate(context);
    }

    public void registerExtension(Extension extension) throws Exception {
        String extensionPoint = extension.getExtensionPoint();
        if (extensionPoint.equals("config")) {
            this.registerConfig(extension);
        } else {
            log.warn((Object)("unknown extension point: " + extensionPoint));
        }
    }

    public void registerConfig(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            ConfigurationDescriptor config = (ConfigurationDescriptor)contrib;
            for (DocumentDescriptor documentDescriptor : config.getDocuments()) {
                this.registerDocument(documentDescriptor);
            }
        }
    }

    private void registerDocument(DocumentDescriptor documentDescriptor) {
        String docType = documentDescriptor.getType();
        ACL acl = this.defaultPermissions.get(docType);
        if (acl == null) {
            acl = new ACLImpl();
            this.defaultPermissions.put(docType, acl);
        }
        for (PrincipalDescriptor principalDescriptor : documentDescriptor.getPrincipals()) {
            String username = principalDescriptor.getName();
            for (PermissionDescriptor permissionDescriptor : principalDescriptor.getPermissions()) {
                String permission = permissionDescriptor.getPermission();
                boolean granted = permissionDescriptor.isGranted();
                ACE ace = new ACE(username, permission, granted);
                acl.add((Object)ace);
            }
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        this.defaultPermissions.clear();
    }

    public ACL getPermissionsForType(String docType) {
        return this.defaultPermissions.get(docType);
    }
}

