/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.util.LocationManagerPluginExtension;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManagerService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.util.LocationManagerService");
    private static final Log log = LogFactory.getLog(LocationManagerService.class);
    private Map<String, RepositoryLocation> locations = new HashMap<String, RepositoryLocation>();

    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            this.register((LocationManagerPluginExtension)contrib);
        }
    }

    private void register(LocationManagerPluginExtension pluginExtension) {
        String locationName = pluginExtension.getLocationName();
        boolean locationEnabled = pluginExtension.getLocationEnabled();
        log.info((Object)("Registering location manager: " + locationName + (locationEnabled ? "" : " (disabled)")));
        RepositoryLocation locationTempPlugin = new RepositoryLocation(locationName);
        if (this.locations.containsKey(locationName)) {
            if (!locationEnabled) {
                this.locations.remove(locationName);
            }
        } else {
            this.locations.put(locationName, locationTempPlugin);
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        this.locations.clear();
        this.locations = null;
    }

    public Map<String, RepositoryLocation> getAvailableLocations() {
        return this.locations;
    }
}

