/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.impl.UpdateServiceImpl;
import org.nuxeo.connect.update.impl.xml.FormDefinition;
import org.nuxeo.connect.update.impl.xml.FormsDefinition;
import org.nuxeo.connect.update.impl.xml.PackageDefinitionImpl;
import org.nuxeo.connect.update.impl.xml.TaskDefinitionImpl;
import org.nuxeo.connect.update.impl.xml.XmlSerializer;
import org.nuxeo.connect.update.model.Form;
import org.nuxeo.connect.update.model.TaskDefinition;

public class PackageBuilder {
    protected PackageDefinitionImpl def = new PackageDefinitionImpl();
    protected List<FormDefinition> installForms;
    protected List<FormDefinition> uninstallForms;
    protected List<FormDefinition> validationForms;
    protected List<String> platforms = new ArrayList<String>();
    protected List<PackageDependency> dependencies = new ArrayList<PackageDependency>();
    protected LinkedHashMap<String, InputStream> entries = new LinkedHashMap();

    public PackageBuilder() {
        this.installForms = new ArrayList<FormDefinition>();
        this.validationForms = new ArrayList<FormDefinition>();
        this.uninstallForms = new ArrayList<FormDefinition>();
    }

    public PackageBuilder name(String name) {
        this.def.setName(name);
        return this;
    }

    public PackageBuilder version(Version version) {
        this.def.setVersion(version);
        return this;
    }

    public PackageBuilder version(String version) {
        this.def.setVersion(new Version(version));
        return this;
    }

    public PackageBuilder type(String type) {
        this.def.setType(PackageType.getByValue((String)type));
        return this;
    }

    public PackageBuilder type(PackageType type) {
        this.def.setType(type);
        return this;
    }

    public PackageBuilder title(String title) {
        this.def.setTitle(title);
        return this;
    }

    public PackageBuilder description(String description) {
        this.def.setDescription(description);
        return this;
    }

    public PackageBuilder classifier(String classifier) {
        this.def.setClassifier(classifier);
        return this;
    }

    public PackageBuilder vendor(String vendor) {
        this.def.setVendor(vendor);
        return this;
    }

    public PackageBuilder homePage(String homePage) {
        this.def.setHomePage(homePage);
        return this;
    }

    public PackageBuilder installer(TaskDefinition task) {
        this.def.setInstaller(task);
        return this;
    }

    public PackageBuilder installer(String type, boolean restart) {
        this.def.setInstaller(new TaskDefinitionImpl(type, restart));
        return this;
    }

    public PackageBuilder uninstaller(TaskDefinition task) {
        this.def.setUninstaller(task);
        return this;
    }

    public PackageBuilder uninstaller(String type, boolean restart) {
        this.def.setUninstaller(new TaskDefinitionImpl(type, restart));
        return this;
    }

    public PackageBuilder validator(String validator) {
        this.def.setValidator(validator);
        return this;
    }

    public PackageBuilder platform(String platform) {
        this.platforms.add(platform);
        return this;
    }

    public PackageBuilder dependency(String expr) {
        this.dependencies.add(new PackageDependency(expr));
        return this;
    }

    public PackageBuilder addInstallForm(FormDefinition form) {
        this.installForms.add(form);
        return this;
    }

    public PackageBuilder addUninstallForm(FormDefinition form) {
        this.uninstallForms.add(form);
        return this;
    }

    public PackageBuilder addValidationForm(FormDefinition form) {
        this.validationForms.add(form);
        return this;
    }

    public PackageBuilder addLicense(String content) {
        return this.addLicense(new ByteArrayInputStream(content.getBytes()));
    }

    public PackageBuilder addLicense(InputStream in) {
        return this.addEntry("license.txt", in);
    }

    public PackageBuilder addInstallScript(String content) {
        return this.addInstallScript(new ByteArrayInputStream(content.getBytes()));
    }

    public PackageBuilder addInstallScript(InputStream in) {
        return this.addEntry("install.xml", in);
    }

    public PackageBuilder addUninstallScript(String content) {
        return this.addUninstallScript(new ByteArrayInputStream(content.getBytes()));
    }

    public PackageBuilder addUninstallScript(InputStream in) {
        return this.addEntry("uninstall.xml", in);
    }

    public PackageBuilder addEntry(String path, InputStream in) {
        this.entries.put(path, in);
        return this;
    }

    public String buildManifest() {
        if (!this.platforms.isEmpty()) {
            this.def.setPlatforms(this.platforms.toArray(new String[this.platforms.size()]));
        }
        if (!this.dependencies.isEmpty()) {
            this.def.setDependencies(this.dependencies.toArray(new PackageDependency[this.dependencies.size()]));
        }
        return new XmlSerializer().toXML(this.def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File build() throws IOException {
        File file;
        try {
            String mf = this.buildManifest();
            File file2 = File.createTempFile(this.def.getId(), ".zip");
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(file2));
            try {
                ZipEntry entry = new ZipEntry("package.xml");
                zout.putNextEntry(entry);
                zout.write(mf.getBytes());
                zout.closeEntry();
                for (Map.Entry<String, InputStream> stream : this.entries.entrySet()) {
                    entry = new ZipEntry(stream.getKey());
                    zout.putNextEntry(entry);
                    FileUtils.copy((InputStream)stream.getValue(), (OutputStream)zout);
                    zout.closeEntry();
                }
                if (!this.installForms.isEmpty()) {
                    this.addForms(this.installForms, "forms/install.xml", zout);
                }
                if (!this.uninstallForms.isEmpty()) {
                    this.addForms(this.uninstallForms, "forms/uninstall.xml", zout);
                }
                if (!this.validationForms.isEmpty()) {
                    this.addForms(this.validationForms, "forms/validation.xml", zout);
                }
            }
            finally {
                zout.close();
            }
            file = file2;
        }
        catch (Throwable throwable) {
            for (InputStream in : this.entries.values()) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            throw throwable;
        }
        for (InputStream in : this.entries.values()) {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return file;
    }

    protected void addForms(List<FormDefinition> formDefs, String path, ZipOutputStream zout) throws IOException {
        int i = 0;
        FormsDefinition forms = new FormsDefinition();
        Form[] ar = new FormDefinition[formDefs.size()];
        for (FormDefinition form : formDefs) {
            ar[i++] = form;
        }
        forms.setForms(ar);
        String xml = new XmlSerializer().toXML(forms);
        ZipEntry entry = new ZipEntry(path);
        zout.putNextEntry(entry);
        FileUtils.copy((InputStream)new ByteArrayInputStream(xml.getBytes()), (OutputStream)zout);
        zout.closeEntry();
    }

    public static void main(String[] args) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.name("nuxeo-automation").version("5.3.2").type(PackageType.ADDON);
        builder.title("Nuxeo Automation").description("The automation framework");
        builder.platform("dm-5.3.2");
        builder.dependency("nuxeo-core:5.3.2");
        builder.classifier("OpenSource");
        builder.installer("MyInstaller", true);
        builder.addLicense("My License");
        String xml = builder.buildManifest();
        System.out.println(xml);
        XMap xmap = UpdateServiceImpl.createXmap();
        PackageDefinitionImpl pdef = (PackageDefinitionImpl)xmap.load((InputStream)new ByteArrayInputStream(xml.getBytes()));
        System.out.println(pdef);
        File file = builder.build();
        System.out.println(file);
        file.delete();
    }
}

