/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OpenSocialMessageType implements MessageTypeInt
{
    FAILED_TO_RETRIEVE_EXTERNAL_URI("%s - Failed to resolve URI %s: %s", MessageLevel.ERROR),
    NO_CONTENT("%s: no content", MessageLevel.FATAL_ERROR);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private OpenSocialMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }
}

