/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.TypeRegistry;
import org.nuxeo.ecm.platform.types.TypeWidget;
import org.nuxeo.ecm.platform.types.TypeWidgetRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class TypeService
extends DefaultComponent
implements TypeManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.types.TypeService");
    private static final Log log = LogFactory.getLog(TypeService.class);
    private TypeRegistry typeRegistry;
    private TypeWidgetRegistry typeWidgetRegistry;

    public void activate(ComponentContext context) {
        this.typeRegistry = new TypeRegistry();
        this.typeWidgetRegistry = new TypeWidgetRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.typeRegistry = null;
        this.typeWidgetRegistry = null;
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("types")) {
            this.typeRegistry.registerExtension(extension);
        } else if (xp.equals("default_layout")) {
            this.registerTypeWidgetExtension(extension);
        }
    }

    public void unregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("types")) {
            this.typeRegistry.unregisterExtension(extension);
        }
        if (xp.equals("default_layout")) {
            this.unregisterTypeWidgetExtension(extension);
        }
    }

    public void registerTypeWidgetExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        log.warn((Object)"The type widget contribution system is deprecated, use the new layout system instead");
        for (Object contrib : contribs) {
            TypeWidget typeWidget = (TypeWidget)contrib;
            this.typeWidgetRegistry.addTypeWidget(typeWidget);
        }
    }

    public void unregisterTypeWidgetExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            TypeWidget typeWidget = (TypeWidget)contrib;
            this.typeWidgetRegistry.removeTypeWidget(typeWidget.getFieldtype());
        }
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public TypeWidgetRegistry getTypeWidgetRegistry() {
        return this.typeWidgetRegistry;
    }

    public String[] getSuperTypes(String typeName) {
        try {
            SchemaManager schemaMgr = (SchemaManager)Framework.getService(SchemaManager.class);
            DocumentType type = schemaMgr.getDocumentType(typeName);
            if (type == null) {
                return null;
            }
            ArrayList<String> superTypes = new ArrayList<String>();
            for (type = (DocumentType)type.getSuperType(); type != null; type = (DocumentType)type.getSuperType()) {
                superTypes.add(type.getName());
            }
            return superTypes.toArray(new String[superTypes.size()]);
        }
        catch (Exception e) {
            log.error((Object)"Failed to lookup the SchemaManager service", (Throwable)e);
            return new String[0];
        }
    }

    public Type getType(String typeName) {
        return this.typeRegistry.getType(typeName);
    }

    public boolean hasType(String typeName) {
        return this.typeRegistry.hasType(typeName);
    }

    public Collection<Type> getTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(this.typeRegistry.getTypes());
        return types;
    }

    public Collection<Type> getAllowedSubTypes(String typeName) {
        ArrayList<Type> allowed = new ArrayList<Type>();
        Type type = this.getType(typeName);
        if (type != null) {
            for (String subTypeName : type.getAllowedSubTypes().keySet()) {
                Type subType = this.getType(subTypeName);
                if (subType == null) continue;
                allowed.add(subType);
            }
        }
        return allowed;
    }
}

