/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server.jaxrs;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.ServiceManager;
import org.apache.abdera.protocol.server.servlet.ServletRequestContext;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryManager;
import org.apache.chemistry.atompub.server.CMISChildrenCollection;
import org.apache.chemistry.atompub.server.CMISProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Path(value="cmis")
public class AbderaResource {
    private static final Log log = LogFactory.getLog(AbderaResource.class);
    public String thisResourcePath = "cmis";
    protected CMISProvider provider;
    @Context
    protected HttpServletRequest httpRequest;
    @Context
    protected UriInfo ui;
    public static PathMunger pathMunger;

    public AbderaResource() throws Exception {
        try {
            Repository repository = RepositoryManager.getInstance().getDefaultRepository();
            this.provider = new CMISProvider(repository);
            this.provider.init(ServiceManager.getAbdera(), new HashMap());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    protected ServletRequestContext getRequestContext() {
        String servletPath;
        String contextPath;
        String cpath = this.httpRequest.getContextPath();
        String spath = this.httpRequest.getServletPath();
        List matchedURIs = this.ui.getMatchedURIs();
        String rpath = matchedURIs.size() > 1 ? (String)matchedURIs.get(matchedURIs.size() - 1) : this.thisResourcePath;
        final String resourcePath = '/' + rpath;
        if (pathMunger == null) {
            contextPath = cpath;
            servletPath = spath;
        } else {
            PathMunger.ContextAndServletPath cs = pathMunger.munge(this.httpRequest, cpath, spath);
            contextPath = cs.contextPath;
            servletPath = cs.servletPath;
        }
        Object wrapper = cpath.equals(contextPath) && spath.equals(servletPath + resourcePath) ? this.httpRequest : new HttpServletRequestWrapper(this.httpRequest){

            public String getContextPath() {
                return contextPath;
            }

            public String getServletPath() {
                return servletPath + resourcePath;
            }

            public String getRequestURI() {
                String uri = super.getRequestURI();
                String cs = super.getContextPath() + super.getServletPath();
                return contextPath + servletPath + uri.substring(cs.length());
            }
        };
        return new ServletRequestContext((Provider)this.provider, (HttpServletRequest)wrapper);
    }

    protected CollectionAdapter getAbderaCollectionAdapter(RequestContext requestContext) {
        return this.provider.getWorkspaceManager(requestContext).getCollectionAdapter(requestContext);
    }

    protected Response getResponse(ResponseContext responseContext) {
        IRI contentLocation;
        Response.ResponseBuilder b = Response.status((int)responseContext.getStatus());
        b.entity((Object)responseContext);
        String contentType = responseContext.getHeader("Content-Type");
        b.type(contentType);
        IRI location = responseContext.getLocation();
        if (location != null) {
            try {
                b.location(location.toURI());
            }
            catch (Exception e) {
                log.error((Object)("Bad Location: " + location), (Throwable)e);
            }
        }
        if ((contentLocation = responseContext.getContentLocation()) != null) {
            try {
                b.contentLocation(contentLocation.toURI());
            }
            catch (Exception e) {
                log.error((Object)("Bad Content-Location: " + contentLocation), (Throwable)e);
            }
        }
        return b.build();
    }

    protected Response getAbderaFeed() {
        ServletRequestContext requestContext = this.getRequestContext();
        CollectionAdapter adapter = this.getAbderaCollectionAdapter((RequestContext)requestContext);
        if (adapter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getResponse(adapter.getFeed((RequestContext)requestContext));
    }

    protected Response getAbderaEntry() {
        ServletRequestContext requestContext = this.getRequestContext();
        CollectionAdapter adapter = this.getAbderaCollectionAdapter((RequestContext)requestContext);
        if (adapter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getResponse(adapter.getEntry((RequestContext)requestContext));
    }

    protected Response postAbderaEntry() {
        ServletRequestContext requestContext = this.getRequestContext();
        CollectionAdapter adapter = this.getAbderaCollectionAdapter((RequestContext)requestContext);
        if (adapter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getResponse(adapter.postEntry((RequestContext)requestContext));
    }

    protected Response putAbderaEntry() {
        ServletRequestContext requestContext = this.getRequestContext();
        CollectionAdapter adapter = this.getAbderaCollectionAdapter((RequestContext)requestContext);
        if (adapter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getResponse(adapter.putEntry((RequestContext)requestContext));
    }

    protected Response deleteAbderaEntry() {
        ServletRequestContext requestContext = this.getRequestContext();
        CollectionAdapter adapter = this.getAbderaCollectionAdapter((RequestContext)requestContext);
        if (adapter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getResponse(adapter.deleteEntry((RequestContext)requestContext));
    }

    @GET
    @Produces(value={"application/atomsvc+xml"})
    @Path(value="repository")
    public Response doGetRepository(@Context HttpServletRequest httpRequest) {
        ServletRequestContext requestContext = this.getRequestContext();
        return this.getResponse(this.provider.getServiceDocument((RequestContext)requestContext));
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="typechildren")
    public Response doGetTypeChildrenAll() {
        return this.getAbderaFeed();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="typechildren/{typeid}")
    public Response doGetTypeChildren() {
        return this.getAbderaFeed();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="typedescendants")
    public Response doGetTypeDescendantsAll() {
        return this.getAbderaFeed();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="typedescendants/{typeid}")
    public Response doGetTypeDescendants() {
        return this.getAbderaFeed();
    }

    @GET
    @Produces(value={"application/atom+xml;type=entry"})
    @Path(value="type/{typeid}")
    public Response doGetType() {
        return this.getAbderaEntry();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="parents/{objectid}")
    public Response doGetParents() {
        return this.getAbderaFeed();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="children/{objectid}")
    public Response doGetChildren() {
        return this.getAbderaFeed();
    }

    @POST
    @Consumes(value={"application/atom+xml;type=entry", "application/atom+xml", "application/atom+xml;type=entry;charset=UTF-8"})
    @Path(value="children/{objectid}")
    public Response doPostChildren() {
        return this.postAbderaEntry();
    }

    @GET
    @Produces(value={"application/cmistree+xml"})
    @Path(value="descendants/{objectid}")
    public Response doGetDescendants() {
        return this.getAbderaFeed();
    }

    @DELETE
    @Path(value="descendants/{objectid}")
    public Response doDeleteDescendants() {
        return this.deleteAbderaEntry();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="foldertree/{objectid}")
    public Response doGetFolderTree() {
        return this.getAbderaFeed();
    }

    @DELETE
    @Path(value="foldertree/{objectid}")
    public Response doDeleteFolderTree() {
        return this.deleteAbderaEntry();
    }

    @GET
    @Produces(value={"application/atom+xml;type=entry"})
    @Path(value="object")
    public Response doGetObjectNoId() {
        return this.getAbderaEntry();
    }

    @GET
    @Produces(value={"application/atom+xml;type=entry"})
    @Path(value="object/{objectid}")
    public Response doGetObject() {
        return this.getAbderaEntry();
    }

    @PUT
    @Consumes(value={"application/atom+xml;type=entry", "application/atom+xml"})
    @Produces(value={"application/atom+xml;type=entry"})
    @Path(value="object/{objectid}")
    public Response doPutObject() {
        return this.putAbderaEntry();
    }

    @DELETE
    @Path(value="object/{objectid}")
    public Response deleteObject() {
        return this.deleteAbderaEntry();
    }

    @GET
    @Produces(value={"application/atom+xml;type=entry"})
    @Path(value="path/{path:.*}")
    public Response doGetObjectByPath() {
        return this.getAbderaEntry();
    }

    @GET
    @Path(value="file/{objectid}")
    public Response doGetFile() {
        ServletRequestContext requestContext = this.getRequestContext();
        CMISChildrenCollection adapter = (CMISChildrenCollection)this.getAbderaCollectionAdapter((RequestContext)requestContext);
        return this.getResponse(adapter.getMedia((RequestContext)requestContext));
    }

    @PUT
    @Path(value="file/{objectid}")
    public Response doPutFile() {
        ServletRequestContext requestContext = this.getRequestContext();
        CMISChildrenCollection adapter = (CMISChildrenCollection)this.getAbderaCollectionAdapter((RequestContext)requestContext);
        return this.getResponse(adapter.putMedia((RequestContext)requestContext));
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="query")
    public Response doGetQuery() {
        return this.getAbderaEntry();
    }

    @POST
    @Consumes(value={"application/cmisquery+xml"})
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="query")
    public Response doPostQuery() {
        return this.postAbderaEntry();
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    @Path(value="checkedout")
    public Response doGetCheckedOut() {
        return this.getAbderaFeed();
    }

    public static interface PathMunger {
        public ContextAndServletPath munge(HttpServletRequest var1, String var2, String var3);

        public static class ContextAndServletPath {
            public String contextPath;
            public String servletPath;
        }
    }
}

