/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.JbpmTaskService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.TaskCreateDateComparator;
import org.nuxeo.ecm.platform.jbpm.TaskVariableFilter;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;

@Name(value="jbpmTaskActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class JbpmTaskActionsBean
extends DocumentContextBoundActionBean {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient JbpmService jbpmService;
    @In(create=true)
    protected transient JbpmTaskService jbpmTaskService;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected List<TaskInstance> tasks;

    @Factory(value="currentSingleTasks", scope=ScopeType.EVENT)
    public List<TaskInstance> getCurrentDocumentTasks() throws NuxeoJbpmException {
        if (this.tasks == null) {
            this.tasks = new ArrayList<TaskInstance>();
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument != null) {
                this.tasks.addAll(this.jbpmService.getTaskInstances(currentDocument, (NuxeoPrincipal)null, (JbpmListFilter)new TaskVariableFilter(JbpmTaskService.TaskVariableName.createdFromTaskService.name(), "true")));
                Collections.sort(this.tasks, new TaskCreateDateComparator());
            }
        }
        return this.tasks;
    }

    public void acceptTask(TaskInstance task, String comment) throws NuxeoJbpmException {
        this.jbpmTaskService.acceptTask(this.documentManager, (NuxeoPrincipal)this.documentManager.getPrincipal(), task, comment);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
    }

    public void rejectTask(TaskInstance task, String comment) throws NuxeoJbpmException {
        this.jbpmTaskService.rejectTask(this.documentManager, (NuxeoPrincipal)this.documentManager.getPrincipal(), task, comment);
        Events.instance().raiseEvent("workflowTaskRejected", new Object[0]);
    }

    public void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.resetCache();
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStart", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled", "domainSelectionChanged", "documentPublicationRejected", "documentPublished"}, create=false, inject=false)
    @BypassInterceptors
    public void resetCache() {
        this.tasks = null;
    }
}

