/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.Collections;
import java.util.Map;
import org.jboss.seam.pageflow.Pageflow;
import org.jbpm.graph.def.Transition;
import org.nuxeo.ecm.platform.actions.AbstractActionFilter;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;

public class PageFlowActionFilter
extends AbstractActionFilter {
    public static final Map<String, Transition> EMPTY_TRANSITION_MAP = Collections.emptyMap();
    private static final long serialVersionUID = 3003327715065315406L;
    private Map<String, Transition> pageFlowTransitions;

    public PageFlowActionFilter() {
        super("PAGE_FLOW_FILTER", Action.EMPTY_CATEGORIES);
    }

    public Map<String, Transition> getPageflowTransitions() {
        if (this.pageFlowTransitions == null) {
            try {
                this.pageFlowTransitions = Pageflow.instance().getPage().getLeavingTransitionsMap();
            }
            catch (IllegalStateException e) {
                this.pageFlowTransitions = EMPTY_TRANSITION_MAP;
            }
        }
        return this.pageFlowTransitions;
    }

    @Override
    public boolean accept(Action action, ActionContext context) {
        Map<String, Transition> leavingTransitions = this.getPageflowTransitions();
        return leavingTransitions.containsKey(action.getId());
    }
}

