/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.soap.server;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.chemistry.soap.server.CallContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final QName WSSE_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    public static final QName WSSE_USERNAME_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    public static final QName WSSE_USERNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
    public static final QName WSSE_PASSWORD = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
    public static final Set<QName> HEADERS = Collections.singleton(WSSE_SECURITY);

    public Set<QName> getHeaders() {
        return HEADERS;
    }

    public boolean handleMessage(SOAPMessageContext soapContext) {
        if (Boolean.TRUE.equals(soapContext.get((Object)"javax.xml.ws.handler.message.outbound"))) {
            return this.handleOutboundMessage(soapContext);
        }
        return this.handleInboundMessage(soapContext);
    }

    protected boolean handleInboundMessage(SOAPMessageContext soapContext) {
        CallContext callContext = this.extractUsernamePassword(soapContext);
        callContext.setInMessageContext((MessageContext)soapContext);
        return true;
    }

    protected CallContext extractUsernamePassword(SOAPMessageContext soapContext) {
        SOAPHeader sh;
        try {
            sh = soapContext.getMessage().getSOAPHeader();
        }
        catch (SOAPException e) {
            throw new RuntimeException("Cannot get SOAP header", e);
        }
        String username = "";
        String password = "";
        try {
            SOAPElement security = (SOAPElement)sh.getChildElements(WSSE_SECURITY).next();
            SOAPElement token = (SOAPElement)security.getChildElements(WSSE_USERNAME_TOKEN).next();
            try {
                SOAPElement usernameElement = (SOAPElement)token.getChildElements(WSSE_USERNAME).next();
                username = usernameElement.getTextContent();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            try {
                SOAPElement passwordElement = (SOAPElement)token.getChildElements(WSSE_PASSWORD).next();
                password = passwordElement.getTextContent();
            }
            catch (NoSuchElementException e) {}
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        CallContext callContext = new CallContext();
        callContext.setUsername(username);
        callContext.setPassword(password);
        return callContext;
    }

    protected boolean handleOutboundMessage(SOAPMessageContext soapContext) {
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

