/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.soap.server;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Paging;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryManager;
import org.apache.chemistry.SPI;
import org.apache.chemistry.soap.server.CallContext;
import org.apache.chemistry.soap.server.ChemistryHelper;
import org.apache.chemistry.ws.CmisException;
import org.apache.chemistry.ws.CmisExtensionType;
import org.apache.chemistry.ws.CmisObjectListType;
import org.apache.chemistry.ws.DiscoveryServicePort;
import org.apache.chemistry.ws.EnumIncludeRelationships;
import org.apache.chemistry.ws.Query;
import org.apache.chemistry.ws.QueryResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="DiscoveryServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", serviceName="DiscoveryService", portName="DiscoveryServicePort", endpointInterface="org.apache.chemistry.ws.DiscoveryServicePort")
public class DiscoveryServicePortImpl
implements DiscoveryServicePort {
    @Resource
    private WebServiceContext wscontext;

    public QueryResponse query(Query parameters) throws CmisException {
        SPI spi = null;
        try {
            String repositoryId = parameters.getRepositoryId();
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            String statement = parameters.getStatement();
            JAXBElement searchAllVersionsB = parameters.getSearchAllVersions();
            boolean searchAllVersions = searchAllVersionsB == null ? false : (Boolean)searchAllVersionsB.getValue();
            JAXBElement maxItemsBI = parameters.getMaxItems();
            int maxItems = maxItemsBI == null || maxItemsBI.getValue() == null || ((BigInteger)maxItemsBI.getValue()).intValue() < 0 ? 0 : ((BigInteger)maxItemsBI.getValue()).intValue();
            JAXBElement skipCountBI = parameters.getSkipCount();
            int skipCount = skipCountBI == null || skipCountBI.getValue() == null || ((BigInteger)skipCountBI.getValue()).intValue() < 0 ? 0 : ((BigInteger)skipCountBI.getValue()).intValue();
            Paging paging = new Paging(maxItems, skipCount);
            JAXBElement includeAllowableActions = parameters.getIncludeAllowableActions();
            boolean allowableActions = includeAllowableActions == null || includeAllowableActions.getValue() == null ? false : (Boolean)includeAllowableActions.getValue();
            JAXBElement includeRelationships = parameters.getIncludeRelationships();
            RelationshipDirection relationships = includeRelationships == null || includeRelationships.getValue() == null ? null : RelationshipDirection.fromInclusion((String)((EnumIncludeRelationships)includeRelationships.getValue()).name());
            JAXBElement renditionFilter = parameters.getRenditionFilter();
            String renditions = renditionFilter == null || renditionFilter.getValue() == null ? null : (String)renditionFilter.getValue();
            Inclusion inclusion = new Inclusion(null, renditions, relationships, allowableActions, false, false);
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            ListPage res = spi.query(statement, searchAllVersions, inclusion, paging);
            QueryResponse queryResponse = ChemistryHelper.convertQuery((ListPage<ObjectEntry>)res);
            return queryResponse;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }

    public void getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeACL, BigInteger maxItems, CmisExtensionType extension, Holder<CmisObjectListType> objects) throws CmisException {
        throw new UnsupportedOperationException();
    }
}

