/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.soap.server;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Paging;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryManager;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Tree;
import org.apache.chemistry.soap.server.CallContext;
import org.apache.chemistry.soap.server.ChemistryHelper;
import org.apache.chemistry.ws.CmisException;
import org.apache.chemistry.ws.CmisExtensionType;
import org.apache.chemistry.ws.CmisObjectInFolderContainerType;
import org.apache.chemistry.ws.CmisObjectInFolderListType;
import org.apache.chemistry.ws.CmisObjectListType;
import org.apache.chemistry.ws.CmisObjectParentsType;
import org.apache.chemistry.ws.CmisObjectType;
import org.apache.chemistry.ws.EnumIncludeRelationships;
import org.apache.chemistry.ws.NavigationServicePort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="NavigationService", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", serviceName="NavigationService", portName="NavigationServicePort", endpointInterface="org.apache.chemistry.ws.NavigationServicePort")
public class NavigationServicePortImpl
implements NavigationServicePort {
    @Resource
    private WebServiceContext wscontext;

    public CmisObjectListType getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        SPI spi = null;
        try {
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            RelationshipDirection inclrel = ChemistryHelper.convert(includeRelationships);
            boolean inclaa = Boolean.TRUE.equals(includeAllowableActions);
            Inclusion inclusion = new Inclusion(filter, renditionFilter, inclrel, inclaa, false, false);
            int max = maxItems == null || maxItems.intValue() < 0 ? 0 : maxItems.intValue();
            int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
            Paging paging = new Paging(max, skip);
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            ListPage res = spi.getCheckedOutDocuments(spi.newObjectId(folderId), inclusion, paging);
            CmisObjectListType cmisObjectListType = ChemistryHelper.convert((ListPage<ObjectEntry>)res);
            return cmisObjectListType;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }

    public CmisObjectInFolderListType getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        SPI spi = null;
        try {
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            RelationshipDirection inclrel = ChemistryHelper.convert(includeRelationships);
            boolean inclaa = Boolean.TRUE.equals(includeAllowableActions);
            Inclusion inclusion = new Inclusion(filter, renditionFilter, inclrel, inclaa, false, false);
            int max = maxItems == null || maxItems.intValue() < 0 ? 0 : maxItems.intValue();
            int skip = skipCount == null || skipCount.intValue() < 0 ? 0 : skipCount.intValue();
            Paging paging = new Paging(max, skip);
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            ListPage res = spi.getChildren(spi.newObjectId(folderId), inclusion, orderBy, paging);
            CmisObjectInFolderListType cmisObjectInFolderListType = ChemistryHelper.convertInFolder((ListPage<ObjectEntry>)res);
            return cmisObjectInFolderListType;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }

    public List<CmisObjectInFolderContainerType> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, CmisExtensionType extension) throws CmisException {
        SPI spi = null;
        try {
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            int d = depth == null ? -1 : depth.intValue();
            RelationshipDirection inclrel = ChemistryHelper.convert(includeRelationships);
            boolean inclaa = Boolean.TRUE.equals(includeAllowableActions);
            Inclusion inclusion = new Inclusion(filter, renditionFilter, inclrel, inclaa, false, false);
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            String orderBy = null;
            Tree res = spi.getDescendants(spi.newObjectId(folderId), d, orderBy, inclusion);
            List<CmisObjectInFolderContainerType> list = ChemistryHelper.convertForest((Tree<ObjectEntry>)res);
            return list;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }

    public CmisObjectType getFolderParent(String repositoryId, String folderId, String filter, CmisExtensionType extension) throws CmisException {
        SPI spi = null;
        try {
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            ObjectEntry entry = spi.getFolderParent(spi.newObjectId(folderId), filter);
            CmisObjectType cmisObjectType = ChemistryHelper.convert(entry);
            return cmisObjectType;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }

    public List<CmisObjectInFolderContainerType> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, CmisExtensionType extension) throws CmisException {
        SPI spi = null;
        try {
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            int d = depth == null ? -1 : depth.intValue();
            RelationshipDirection inclrel = ChemistryHelper.convert(includeRelationships);
            boolean inclaa = Boolean.TRUE.equals(includeAllowableActions);
            Inclusion inclusion = new Inclusion(filter, renditionFilter, inclrel, inclaa, false, false);
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            Tree res = spi.getFolderTree(spi.newObjectId(folderId), d, inclusion);
            List<CmisObjectInFolderContainerType> list = ChemistryHelper.convertForest((Tree<ObjectEntry>)res);
            return list;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }

    public List<CmisObjectParentsType> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, CmisExtensionType extension) throws CmisException {
        SPI spi = null;
        try {
            Repository repository = RepositoryManager.getInstance().getRepository(repositoryId);
            if (repository == null) {
                String msg = "Unknown repository: " + repositoryId;
                throw new CmisException(msg, null, null);
            }
            RelationshipDirection inclrel = ChemistryHelper.convert(includeRelationships);
            boolean inclaa = Boolean.TRUE.equals(includeAllowableActions);
            Inclusion inclusion = new Inclusion(filter, renditionFilter, inclrel, inclaa, false, false);
            Map<String, Serializable> params = CallContext.mapFromWebServiceContext(this.wscontext);
            spi = repository.getSPI(params);
            Collection res = spi.getObjectParents(spi.newObjectId(objectId), renditionFilter);
            List<CmisObjectParentsType> list = ChemistryHelper.convertParents(res);
            return list;
        }
        catch (Exception e) {
            throw ChemistryHelper.convert(e);
        }
        finally {
            if (spi != null) {
                spi.close();
            }
        }
    }
}

