/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;

public class LayoutRowImpl
implements LayoutRow {
    private static final long serialVersionUID = 1528198770297610864L;
    final Widget[] widgets;
    final Map<String, Serializable> properties;

    public LayoutRowImpl(Widget[] widgets) {
        this.widgets = widgets;
        this.properties = null;
    }

    public LayoutRowImpl(List<Widget> widgets) {
        this.widgets = widgets.toArray(new Widget[0]);
        this.properties = null;
    }

    public LayoutRowImpl(List<Widget> widgets, Map<String, Serializable> properties) {
        this.widgets = widgets.toArray(new Widget[0]);
        this.properties = properties;
    }

    @Override
    public Widget[] getWidgets() {
        return this.widgets;
    }

    @Override
    public int getSize() {
        if (this.widgets != null) {
            return this.widgets.length;
        }
        return 0;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Serializable getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }
}

