/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Children;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public class HierarchyContext {
    private final Model model;
    private final RowMapper mapper;
    private final SessionImpl session;
    private final PersistenceContext context;
    private final Map<Serializable, Children> childrenRegularSoft;
    public final Map<Serializable, Children> childrenRegularHard;
    private final Map<Serializable, Children> childrenComplexPropSoft;
    private final Map<Serializable, Children> childrenComplexPropHard;
    private final Map<Serializable, Children>[] childrenAllMaps;
    private final Set<Serializable> modifiedParentsInTransaction;
    private final SimpleFragment.PositionComparator posComparator;

    public HierarchyContext(Model model, RowMapper mapper, SessionImpl session, PersistenceContext context) {
        this.model = model;
        this.mapper = mapper;
        this.session = session;
        this.context = context;
        this.childrenRegularSoft = new ReferenceMap(0, 1);
        this.childrenRegularHard = new HashMap<Serializable, Children>();
        this.childrenComplexPropSoft = new ReferenceMap(0, 1);
        this.childrenComplexPropHard = new HashMap<Serializable, Children>();
        this.childrenAllMaps = new Map[]{this.childrenRegularSoft, this.childrenRegularHard, this.childrenComplexPropSoft, this.childrenComplexPropHard};
        this.modifiedParentsInTransaction = new HashSet<Serializable>();
        this.posComparator = new SimpleFragment.PositionComparator("pos");
    }

    public int clearCaches() {
        int n = this.childrenRegularSoft.size() + this.childrenComplexPropSoft.size();
        this.childrenRegularSoft.clear();
        this.childrenComplexPropSoft.clear();
        this.modifiedParentsInTransaction.clear();
        return n;
    }

    protected Children childrenCache(Serializable parentId, boolean complexProp) {
        Map<Serializable, Children> hardMap;
        Map<Serializable, Children> softMap;
        if (complexProp) {
            softMap = this.childrenComplexPropSoft;
            hardMap = this.childrenComplexPropHard;
        } else {
            softMap = this.childrenRegularSoft;
            hardMap = this.childrenRegularHard;
        }
        Children children = softMap.get(parentId);
        if (children == null && (children = hardMap.get(parentId)) == null) {
            children = new Children(this, "name", false, parentId, softMap, hardMap);
        }
        return children;
    }

    protected boolean complexProp(SimpleFragment fragment) throws StorageException {
        return (Boolean)fragment.get("isproperty");
    }

    protected void addExistingChild(SimpleFragment fragment, boolean complexProp, boolean invalidate) throws StorageException {
        Serializable parentId = fragment.get("parentid");
        if (parentId == null) {
            return;
        }
        this.childrenCache(parentId, complexProp).addExisting(fragment.getId());
        if (invalidate) {
            this.modifiedParentsInTransaction.add(parentId);
        }
    }

    protected void addCreatedChild(SimpleFragment fragment, boolean complexProp) throws StorageException {
        Serializable parentId = fragment.get("parentid");
        if (parentId == null) {
            return;
        }
        this.childrenCache(parentId, complexProp).addCreated(fragment.getId());
        this.modifiedParentsInTransaction.add(parentId);
    }

    protected void removeChild(SimpleFragment fragment, boolean complexProp) throws StorageException {
        Serializable parentId = fragment.get("parentid");
        if (parentId == null) {
            return;
        }
        this.childrenCache(parentId, complexProp).remove(fragment.getId());
        this.modifiedParentsInTransaction.add(parentId);
    }

    public void createdSimpleFragment(SimpleFragment fragment) throws StorageException {
        if (!"hierarchy".equals(fragment.row.tableName)) {
            return;
        }
        this.addCreatedChild(fragment, this.complexProp(fragment));
        Serializable parentId = fragment.getId();
        new Children(this, "name", true, parentId, this.childrenRegularSoft, this.childrenRegularHard);
        new Children(this, "name", true, parentId, this.childrenComplexPropSoft, this.childrenComplexPropHard);
    }

    public SimpleFragment getChildHierByName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        SimpleFragment fragment = this.childrenCache(parentId, complexProp).getFragmentByValue((Serializable)((Object)name));
        if (fragment == SimpleFragment.UNKNOWN) {
            Row row = this.mapper.readChildHierRow(parentId, name, complexProp);
            fragment = (SimpleFragment)this.context.getFragmentFromFetchedRow(row, false);
        }
        return fragment;
    }

    public List<SimpleFragment> getChildren(Serializable parentId, String name, boolean complexProp) throws StorageException {
        Children children = this.childrenCache(parentId, complexProp);
        List<SimpleFragment> fragments = children.getFragmentsByValue((Serializable)((Object)name));
        if (fragments == null) {
            List<Row> rows = this.mapper.readChildHierRows(parentId, complexProp);
            List<Fragment> frags = this.context.getFragmentsFromFetchedRows(rows, false);
            fragments = new ArrayList<SimpleFragment>(frags.size());
            ArrayList<Serializable> ids = new ArrayList<Serializable>(frags.size());
            for (Fragment fragment : frags) {
                fragments.add((SimpleFragment)fragment);
                ids.add(fragment.getId());
            }
            children.addExistingComplete(ids);
            fragments = children.getFragmentsByValue((Serializable)((Object)name));
        }
        if (this.isOrderable(parentId, complexProp)) {
            Collections.sort(fragments, this.posComparator);
        }
        return fragments;
    }

    protected boolean isOrderable(Serializable parentId, boolean complexProp) throws StorageException {
        if (complexProp) {
            return true;
        }
        SimpleFragment parent = this.getHier(parentId, true);
        String typeName = parent.getString("primarytype");
        return this.model.getDocumentTypeFacets(typeName).contains("Orderable");
    }

    public Serializable getContainingDocument(Serializable id) throws StorageException {
        Serializable pid = id;
        while (pid != null) {
            SimpleFragment p = this.getHier(pid, false);
            if (p == null) {
                return null;
            }
            if (!this.complexProp(p)) {
                return pid;
            }
            pid = p.get("parentid");
        }
        return null;
    }

    protected void checkNotUnder(Serializable parentId, Serializable id, String op) throws StorageException {
        SimpleFragment p;
        Serializable pid = parentId;
        do {
            if (pid.equals(id)) {
                throw new StorageException("Cannot " + op + " a node under itself: " + parentId + " is under " + id);
            }
            p = this.getHier(pid, false);
            if (p == null) {
                throw new StorageException("No parent: " + pid);
            }
        } while ((pid = p.get("parentid")) != null);
    }

    protected void checkFreeName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        SimpleFragment fragment = this.getChildHierByName(parentId, name, complexProp);
        if (fragment != null) {
            throw new StorageException("Destination name already exists: " + name);
        }
    }

    public void orderBefore(Serializable parentId, Serializable sourceId, Serializable destId) throws StorageException {
        boolean complexProp = false;
        if (!this.isOrderable(parentId, complexProp)) {
            return;
        }
        if (sourceId.equals(destId)) {
            return;
        }
        List<SimpleFragment> fragments = this.getChildren(parentId, null, complexProp);
        int i = 0;
        SimpleFragment source = null;
        Long destPos = null;
        for (SimpleFragment fragment : fragments) {
            Long setPos;
            Serializable id = fragment.getId();
            if (id.equals(destId)) {
                destPos = i;
                ++i;
                if (source != null) {
                    source.put("pos", destPos);
                }
            }
            if (id.equals(sourceId)) {
                --i;
                source = fragment;
                setPos = destPos;
            } else {
                setPos = i;
            }
            if (setPos != null) {
                if (!setPos.equals(fragment.get("pos"))) {
                    fragment.put("pos", setPos);
                }
            }
            ++i;
        }
        if (destId == null) {
            Long setPos = i;
            if (!setPos.equals(source.get("pos"))) {
                source.put("pos", setPos);
            }
        }
    }

    public Long getNextPos(Serializable nodeId, boolean complexProp) throws StorageException {
        if (!this.isOrderable(nodeId, complexProp)) {
            return null;
        }
        long max = -1L;
        for (SimpleFragment fragment : this.getChildren(nodeId, null, complexProp)) {
            Long pos = (Long)fragment.get("pos");
            if (pos == null || pos <= max) continue;
            max = pos;
        }
        return max + 1L;
    }

    public void move(Node source, Serializable parentId, String name) throws StorageException {
        Serializable id = source.getId();
        SimpleFragment hierFragment = source.getHierFragment();
        Serializable oldParentId = hierFragment.get("parentid");
        String oldName = hierFragment.getString("name");
        if (!oldParentId.equals(parentId)) {
            this.checkNotUnder(parentId, id, "move");
        } else if (oldName.equals(name)) {
            return;
        }
        boolean complexProp = this.complexProp(hierFragment);
        this.checkFreeName(parentId, name, complexProp);
        if (!oldName.equals(name)) {
            hierFragment.put("name", (Serializable)((Object)name));
        }
        this.removeChild(hierFragment, complexProp);
        hierFragment.put("parentid", parentId);
        this.addExistingChild(hierFragment, complexProp, true);
    }

    public Serializable copy(Node source, Serializable parentId, String name) throws StorageException {
        Serializable id = source.getId();
        SimpleFragment hierFragment = source.getHierFragment();
        Serializable oldParentId = hierFragment.get("parentid");
        if (!oldParentId.equals(parentId)) {
            this.checkNotUnder(parentId, id, "copy");
        }
        this.checkFreeName(parentId, name, this.complexProp(hierFragment));
        String typeName = source.getPrimaryType();
        RowMapper.CopyHierarchyResult res = this.mapper.copyHierarchy(id, typeName, parentId, name, null);
        Serializable newId = res.copyId;
        this.context.markInvalidated(res.invalidations);
        this.getHier(newId, false);
        return newId;
    }

    public void removeNode(Fragment hierFragment) throws StorageException {
        if (hierFragment.getState() == Fragment.State.CREATED) {
            Serializable id = hierFragment.getId();
            for (SimpleFragment f : this.getChildren(id, null, true)) {
                this.context.removeNode(f);
            }
            for (SimpleFragment f : this.getChildren(id, null, false)) {
                this.context.removeNode(f);
            }
        }
    }

    public void removeFragment(Fragment fragment) throws StorageException {
        if (!"hierarchy".equals(fragment.row.tableName)) {
            return;
        }
        this.removeChild((SimpleFragment)fragment, this.complexProp((SimpleFragment)fragment));
    }

    public void postSave() {
        for (Children children : this.childrenRegularHard.values()) {
            children.flush();
        }
        this.childrenRegularHard.clear();
        for (Children children : this.childrenComplexPropHard.values()) {
            children.flush();
        }
        this.childrenComplexPropHard.clear();
    }

    public SimpleFragment getHierIfPresent(Serializable id) {
        RowId rowId = new RowId("hierarchy", id);
        return (SimpleFragment)this.context.getIfPresent(rowId);
    }

    public SimpleFragment getHier(Serializable id, boolean allowAbsent) throws StorageException {
        RowId rowId = new RowId("hierarchy", id);
        return (SimpleFragment)this.context.get(rowId, allowAbsent);
    }

    public void recordFragment(Fragment fragment) throws StorageException {
        if (!"hierarchy".equals(fragment.row.tableName)) {
            return;
        }
        this.addExistingChild((SimpleFragment)fragment, this.complexProp((SimpleFragment)fragment), false);
    }

    public boolean isDeleted(Serializable id) throws StorageException {
        while (id != null) {
            Fragment.State state;
            SimpleFragment fragment = this.getHier(id, false);
            if (fragment == null || (state = fragment.getState()) == Fragment.State.ABSENT || state == Fragment.State.DELETED || state == Fragment.State.INVALIDATED_DELETED) {
                return true;
            }
            id = fragment.get("parentid");
        }
        return false;
    }

    public Serializable checkIn(Node node, String label, String description) throws StorageException {
        Boolean checkedIn = (Boolean)node.hierFragment.get("ischeckedin");
        if (Boolean.TRUE.equals(checkedIn)) {
            throw new StorageException("Already checked in");
        }
        Serializable id = node.getId();
        String typeName = node.getPrimaryType();
        RowMapper.CopyHierarchyResult res = this.mapper.copyHierarchy(id, typeName, null, null, null);
        Serializable newId = res.copyId;
        this.context.markInvalidated(res.invalidations);
        this.getHier(newId, false);
        Row row = new Row("versions", newId);
        row.putNew("versionableid", id);
        row.putNew("created", new GregorianCalendar());
        row.putNew("label", (Serializable)((Object)label));
        row.putNew("description", (Serializable)((Object)description));
        SimpleFragment versionRow = this.context.createSimpleFragment(row);
        node.hierFragment.put("ischeckedin", Boolean.TRUE);
        node.hierFragment.put("baseversionid", newId);
        return newId;
    }

    public void checkOut(Node node) throws StorageException {
        Boolean checkedIn = (Boolean)node.hierFragment.get("ischeckedin");
        if (!Boolean.TRUE.equals(checkedIn)) {
            throw new StorageException("Already checked out");
        }
        node.hierFragment.put("ischeckedin", Boolean.FALSE);
    }

    public void restoreVersion(Node node, Serializable versionId) throws StorageException {
        String typeName = node.getPrimaryType();
        Serializable versionableId = node.getId();
        List<SimpleFragment> children = this.getChildren(versionableId, null, true);
        for (Fragment child : children.toArray(new Fragment[children.size()])) {
            this.context.removeFragment(child);
        }
        this.session.flush();
        Row overwriteRow = new Row("hierarchy", versionableId);
        SimpleFragment versionHier = this.getHier(versionId, false);
        for (String key : this.model.getFragmentKeysType("hierarchy").keySet()) {
            if (key.equals("parentid")) continue;
            if (key.equals("name")) continue;
            if (key.equals("pos")) continue;
            if (key.equals("isproperty")) continue;
            if (key.equals("primarytype")) continue;
            if (key.equals("ischeckedin")) continue;
            if (key.equals("baseversionid")) continue;
            overwriteRow.putNew(key, versionHier.get(key));
        }
        overwriteRow.putNew("ischeckedin", Boolean.TRUE);
        overwriteRow.putNew("baseversionid", versionId);
        RowMapper.CopyHierarchyResult res = this.mapper.copyHierarchy(versionId, typeName, (Serializable)((Object)node.getParentId()), null, overwriteRow);
        this.context.markInvalidated(res.invalidations);
    }

    public void markInvalidated(Set<RowId> modified) {
        for (RowId rowId : modified) {
            if (!"__PARENT__".equals(rowId.tableName)) continue;
            Serializable parentId = rowId.id;
            for (Map<Serializable, Children> map : this.childrenAllMaps) {
                Children children = map.get(parentId);
                if (children == null) continue;
                children.setIncomplete();
            }
            this.modifiedParentsInTransaction.add(parentId);
        }
    }

    public void gatherInvalidations(Invalidations invalidations) {
        for (Serializable id : this.modifiedParentsInTransaction) {
            invalidations.addModified(new RowId("__PARENT__", id));
        }
        this.modifiedParentsInTransaction.clear();
    }

    public void processReceivedInvalidations(Set<RowId> modified) throws StorageException {
        for (RowId rowId : modified) {
            if (!"__PARENT__".equals(rowId.tableName)) continue;
            Serializable parentId = rowId.id;
            for (Map<Serializable, Children> map : this.childrenAllMaps) {
                map.remove(parentId);
            }
        }
    }
}

