/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.storage.StorageException;

public class NamespaceRegistry {
    private static final Map<String, String> DEFAULT_MAPPING;
    private final Map<String, String> prefixToURI = new HashMap<String, String>();
    private final Map<String, String> uriToPrefix = new HashMap<String, String>();

    public NamespaceRegistry() {
        for (Map.Entry<String, String> entry : DEFAULT_MAPPING.entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }
    }

    public String getPrefix(String uri) throws StorageException {
        String prefix = this.uriToPrefix.get(uri);
        if (prefix == null) {
            throw new StorageException(uri);
        }
        return prefix;
    }

    public String[] getPrefixes() {
        return (String[])this.prefixToURI.keySet().toArray();
    }

    public String getURI(String prefix) throws StorageException {
        String uri = this.prefixToURI.get(prefix);
        if (uri == null) {
            throw new StorageException(prefix);
        }
        return uri;
    }

    public String[] getURIs() {
        return (String[])this.uriToPrefix.keySet().toArray();
    }

    public void registerNamespace(String prefix, String uri) throws StorageException {
        if (prefix == null) {
            throw new IllegalArgumentException("Illegal null prefix");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Illegal null uri");
        }
        if (DEFAULT_MAPPING.containsKey(prefix)) {
            if (DEFAULT_MAPPING.get(prefix).equals(uri)) {
                return;
            }
            throw new StorageException("Cannot redefine namespace of system prefix '" + prefix + "'");
        }
        if (DEFAULT_MAPPING.containsValue(uri)) {
            throw new StorageException("Cannot redefine prefix of system namespace '" + uri + "'");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new StorageException("Cannot define namespace for xml prefix '" + prefix + "'");
        }
        String oldPrefix = this.uriToPrefix.get(uri);
        if (prefix.equals(oldPrefix)) {
            return;
        }
        if (this.prefixToURI.containsKey(prefix)) {
            throw new StorageException("Reregistering prefix '" + prefix + "' is not supported");
        }
        if (oldPrefix != null) {
            throw new StorageException("Cannot reregister namespace '" + uri + "'");
        }
        this.prefixToURI.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    public void unregisterNamespace(String prefix) throws StorageException {
        if (prefix == null) {
            throw new IllegalArgumentException("Illegal null prefix");
        }
        if (DEFAULT_MAPPING.containsKey(prefix)) {
            throw new StorageException("Cannot unregister system prefix '" + prefix + "'");
        }
        throw new StorageException("Unregistering prefix '" + prefix + "' is not supported");
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", "");
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        map.put("xmlns", "http://www.w3.org/2000/xmlns/");
        map.put("jcr", "http://www.jcp.org/jcr/1.0");
        map.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        map.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        map.put("sv", "http://www.jcp.org/jcr/sv/1.0");
        DEFAULT_MAPPING = Collections.unmodifiableMap(map);
    }
}

