/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.IOException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryScrambler;
import org.nuxeo.ecm.core.storage.sql.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;

public class XORBinaryManager
extends DefaultBinaryManager {
    protected byte[] pattern;

    @Override
    public void initialize(RepositoryDescriptor repositoryDescriptor) throws IOException {
        byte[] pattern;
        super.initialize(repositoryDescriptor);
        String key = repositoryDescriptor.binaryManagerKey;
        if (key == null || key.length() == 0) {
            key = "U";
        }
        try {
            pattern = key.getBytes("UTF-8");
        }
        catch (Exception e) {
            pattern = new byte[]{85};
        }
        this.pattern = pattern;
    }

    @Override
    protected BinaryScrambler getBinaryScrambler() {
        return new XORBinaryScrambler(this.pattern);
    }

    public static class XORBinaryScrambler
    implements BinaryScrambler {
        protected final byte[] pattern;
        protected long pos;

        public XORBinaryScrambler(byte[] pattern) {
            this.pattern = pattern;
            this.pos = 0L;
        }

        @Override
        public void scrambleBuffer(byte[] buf, int off, int n) {
            for (int i = 0; i < n; ++i) {
                int n2 = off + i;
                buf[n2] = (byte)(buf[n2] ^ this.pattern[(int)(this.pos % (long)this.pattern.length)]);
                ++this.pos;
            }
        }

        @Override
        public void unscrambleBuffer(byte[] buf, int off, int n) {
            this.scrambleBuffer(buf, off, n);
        }

        @Override
        public Binary getUnscrambledBinary(File file, String digest) {
            return new DefaultBinaryManager.ScrambledBinary(file, digest, this);
        }

        @Override
        public void skip(long n) {
            this.pos += n;
        }

        @Override
        public void reset() {
            this.pos = 0L;
        }
    }
}

