/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSimpleProperty;
import org.nuxeo.ecm.core.versioning.DocumentVersion;
import org.nuxeo.ecm.core.versioning.DocumentVersionIterator;

public class SQLDocumentVersion
extends SQLDocumentLive
implements DocumentVersion {
    private final Node versionableNode;
    protected static final DocumentVersionIterator EMPTY_VERSION_ITERATOR = new DocumentVersionIterator(){

        public boolean hasNext() {
            return false;
        }

        public DocumentVersion next() {
            throw new NoSuchElementException();
        }

        public DocumentVersion nextDocumentVersion() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    protected SQLDocumentVersion(Node node, ComplexType type, SQLSession session, boolean readonly) throws DocumentException {
        super(node, type, session, readonly);
        this.versionableNode = session.getNodeById((Serializable)this.getProperty("ecm:versionableId").getValue());
    }

    public String getLabel() throws DocumentException {
        return this.getString("ecm:versionLabel");
    }

    public String getDescription() throws DocumentException {
        return this.getString("ecm:versionDescription");
    }

    public Calendar getCreated() throws DocumentException {
        return this.getDate("ecm:versionCreated");
    }

    public DocumentVersion[] getPredecessors() {
        throw new UnsupportedOperationException();
    }

    public DocumentVersion[] getSuccessors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVersion() {
        return true;
    }

    @Override
    public Document getSourceDocument() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getDocumentByUUID(this.versionableNode.getId().toString());
    }

    @Override
    public String getPath() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getPath(this.versionableNode);
    }

    @Override
    public Document getParent() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getParent(this.versionableNode);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public void removeChild(String name) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public void orderBefore(String src, String dest) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document addChild(String name, String typeName) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getChild(String name) throws DocumentException {
        throw new NoSuchDocumentException(name);
    }

    @Override
    public Iterator<Document> getChildren() throws DocumentException {
        return EmptyDocumentIterator.INSTANCE;
    }

    @Override
    public List<String> getChildrenIds() throws DocumentException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChild(String name) throws DocumentException {
        return false;
    }

    @Override
    public boolean hasChildren() throws DocumentException {
        return false;
    }

    @Override
    public void checkIn(String label) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void checkIn(String label, String description) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void checkOut() {
        throw new VersionNotModifiableException();
    }

    @Override
    public boolean isCheckedOut() {
        return false;
    }

    @Override
    public void restore(String label) {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getVersion(String label) {
        return null;
    }

    @Override
    public DocumentVersionIterator getVersions() {
        return EMPTY_VERSION_ITERATOR;
    }

    @Override
    public boolean hasVersions() {
        return false;
    }

    @Override
    public DocumentVersion getLastVersion() {
        return null;
    }

    @Override
    public void importFlatMap(Map<String, Object> map) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void importMap(Map<String, Map<String, Object>> map) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setPropertyValue(String name, Object value) throws DocumentException {
        if (this.readonly && !SQLSimpleProperty.VERSION_WRITABLE_PROPS.contains(name)) {
            throw new VersionNotModifiableException(String.format("Cannot set property on a version: %s = %s", name, value));
        }
        super.setPropertyValue(name, value);
    }

    @Override
    public void setString(String name, String value) throws DocumentException {
        if (this.readonly && !SQLSimpleProperty.VERSION_WRITABLE_PROPS.contains(name)) {
            throw new VersionNotModifiableException();
        }
        super.setString(name, value);
    }

    @Override
    public void setBoolean(String name, boolean value) throws DocumentException {
        if (this.readonly && !SQLSimpleProperty.VERSION_WRITABLE_PROPS.contains(name)) {
            throw new VersionNotModifiableException();
        }
        super.setBoolean(name, value);
    }

    @Override
    public void setLong(String name, long value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setDouble(String name, double value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setDate(String name, Calendar value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setContent(String name, Blob value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void removeProperty(String name) {
        throw new VersionNotModifiableException();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocumentVersion) {
            return this.equals((SQLDocumentVersion)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentVersion other) {
        return this.getNode().equals((Object)other.getNode());
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    public static class VersionNotModifiableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VersionNotModifiableException() {
        }

        public VersionNotModifiableException(String message) {
            super(message);
        }
    }
}

