/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.net.BinaryRequestEntity;

public class BinaryManagerClient
implements BinaryManager {
    private static final Log log = LogFactory.getLog(BinaryManagerClient.class);
    protected final BinaryManager binaryManager;
    protected final HttpClient httpClient;
    protected String url;

    public BinaryManagerClient(BinaryManager binaryManager, HttpClient httpClient) {
        this.binaryManager = binaryManager;
        this.httpClient = httpClient;
    }

    @Override
    public void initialize(RepositoryDescriptor repositoryDescriptor) throws IOException {
        this.url = BinaryManagerClient.getUrl(repositoryDescriptor);
    }

    protected static String getUrl(RepositoryDescriptor repositoryDescriptor) {
        RepositoryDescriptor.ServerDescriptor sd = repositoryDescriptor.connect.get(0);
        return sd.getUrl() + '/' + "binary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getBinary(InputStream in) throws IOException {
        Binary binary = this.binaryManager.getBinary(in);
        PostMethod m = new PostMethod(this.url + BinaryManagerClient.getQuery(binary.getDigest()));
        try {
            BinaryRequestEntity writer = new BinaryRequestEntity(binary);
            m.setRequestEntity((RequestEntity)writer);
            int status = this.httpClient.executeMethod((HttpMethod)m);
            if (status != 201) {
                log.error((Object)String.format("Could not create remote binary on server %s (%s)", this.url, String.valueOf(status)));
            }
        }
        catch (IOException e) {
            log.error((Object)String.format("Could not create remote binary on server %s (%s)", this.url, e.toString()), (Throwable)e);
        }
        finally {
            m.releaseConnection();
        }
        return binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getBinary(String digest) {
        Binary binary = this.binaryManager.getBinary(digest);
        if (binary != null) {
            return binary;
        }
        GetMethod m = new GetMethod(this.url + BinaryManagerClient.getQuery(digest));
        try {
            int status = this.httpClient.executeMethod((HttpMethod)m);
            if (status == 404) {
                Binary binary2 = null;
                return binary2;
            }
            if (status != 200) {
                log.error((Object)String.format("Could not get remote binary on server %s (%s)", this.url, String.valueOf(status)));
                Binary binary3 = null;
                return binary3;
            }
            binary = this.binaryManager.getBinary(m.getResponseBodyAsStream());
        }
        catch (IOException e) {
            log.error((Object)String.format("Could not get remote binary on server %s (%s)", this.url, e.toString()), (Throwable)e);
            Binary binary4 = null;
            return binary4;
        }
        finally {
            m.releaseConnection();
        }
        if (binary.getDigest().equals(digest)) {
            return binary;
        }
        log.error((Object)("Remote binary digest  mismatch: '" + digest + "' vs '" + binary.getDigest() + "'"));
        return null;
    }

    protected static String getQuery(String digest) {
        try {
            digest = URLEncoder.encode(digest, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "?digest=" + digest;
    }
}

