/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.nuxeo.ecm.core.api.WrappedException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.CachingRowMapper;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.net.MapperClientInfo;

public class MapperInvoker
extends Thread {
    private static final String INVOKER_INIT = "__init";
    private static final String INVOKER_CLOSE = "__close";
    private static final Map<String, Method> mapperMethods = new HashMap<String, Method>();
    private final Repository repository;
    private final InvalidationsQueue eventQueue;
    private Session session;
    private Mapper mapper;
    private MapperClientInfo info;
    protected MapperClientInfo clientInfo;
    protected final BlockingQueue<MethodCall> methodCalls;
    protected final BlockingQueue<MethodResult> methodResults;

    public MapperInvoker(Repository repository, String name, InvalidationsQueue eventQueue, MapperClientInfo info) throws Throwable {
        super(name);
        this.repository = repository;
        this.eventQueue = eventQueue;
        this.methodCalls = new LinkedBlockingQueue<MethodCall>(1);
        this.methodResults = new LinkedBlockingQueue<MethodResult>(1);
        this.clientInfo = info;
        this.start();
        this.init();
    }

    public void init() throws Throwable {
        this.call(INVOKER_INIT, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Throwable {
        try {
            this.call(INVOKER_CLOSE, new Object[0]);
        }
        finally {
            this.interrupt();
            this.join();
        }
    }

    public Object call(String methodName, Object ... args) throws Throwable {
        this.methodCalls.put(new MethodCall(methodName, args));
        return this.methodResults.take().result;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Object res;
                MethodCall call = this.methodCalls.take();
                try {
                    res = this.localCall(call.methodName, call.args);
                }
                catch (InvocationTargetException e) {
                    res = WrappedException.wrap((Throwable)e.getCause());
                }
                catch (Exception e) {
                    res = WrappedException.wrap((Throwable)e);
                }
                this.methodResults.put(new MethodResult(res));
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected Object localCall(String methodName, Object[] args) throws Exception {
        if (methodName == INVOKER_INIT) {
            this.session = this.repository.getConnection();
            this.mapper = this.session.getMapper();
            ((CachingRowMapper)((Object)this.mapper)).setEventQueue(this.eventQueue);
            return null;
        }
        if (methodName == INVOKER_CLOSE) {
            this.session.close();
            this.mapper = null;
            return null;
        }
        if ("close".equals(methodName)) {
            return null;
        }
        Method method = mapperMethods.get(methodName);
        if (method == null) {
            throw new StorageException("Unknown Mapper method: " + methodName);
        }
        return method.invoke((Object)this.mapper, args);
    }

    static {
        for (Method m : Mapper.class.getMethods()) {
            mapperMethods.put(m.getName(), m);
        }
    }

    protected static final class MethodResult {
        public final Object result;

        public MethodResult(Object result) {
            this.result = result;
        }
    }

    protected static final class MethodCall {
        public final String methodName;
        public final Object[] args;

        public MethodCall(String methodName, Object[] args) {
            this.methodName = methodName;
            this.args = args;
        }
    }
}

