/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.CleanupHandler;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;

public class OperationContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 2944230823597903715L;
    protected transient CoreSession session;
    protected boolean commit = true;
    protected final transient List<CleanupHandler> cleanupHandlers;
    protected final transient Map<String, List<Object>> stacks = new HashMap<String, List<Object>>();
    protected Object input;

    public OperationContext() {
        this((CoreSession)null);
    }

    public OperationContext(CoreSession session) {
        this.session = session;
        this.cleanupHandlers = new ArrayList<CleanupHandler>();
    }

    public void setCoreSession(CoreSession session) {
        this.session = session;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public CoreSession getCoreSession() {
        return this.session;
    }

    public Principal getPrincipal() {
        return this.session != null ? this.session.getPrincipal() : null;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public Object peek(String type) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        return stack.isEmpty() ? null : stack.get(stack.size() - 1);
    }

    public void push(String type, Object obj) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            stack = new ArrayList<Object>();
            this.stacks.put(type, stack);
        }
        stack.add(obj);
    }

    public Object pop(String type) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        return stack.isEmpty() ? null : stack.remove(stack.size() - 1);
    }

    public Object pull(String type) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        return stack.isEmpty() ? null : stack.remove(0);
    }

    public <T> T getAdapter(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(CoreSession.class)) {
            return type.cast(this.session);
        }
        if (type.isAssignableFrom(Principal.class)) {
            return type.cast(this.getPrincipal());
        }
        try {
            return (T)Framework.getService(type);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup service: " + type, e);
        }
    }

    public void addCleanupHandler(CleanupHandler handler) {
        this.cleanupHandlers.add(handler);
    }

    public void removeCleanupHandler(CleanupHandler handler) {
        this.cleanupHandlers.remove(handler);
    }

    public void dispose() {
        for (CleanupHandler handler : this.cleanupHandlers) {
            try {
                handler.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

