/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Blob.Post", category="Files", label="HTTP Post", description="Post the input file to a target HTTP URL. Returns back the input file.")
public class PostBlob {
    public static final String ID = "Blob.Post";
    @Param(name="url")
    protected String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        URL target = new URL(this.url);
        URLConnection conn = target.openConnection();
        conn.setDoOutput(true);
        InputStream in = blob.getStream();
        OutputStream out = conn.getOutputStream();
        try {
            FileUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        finally {
            in.close();
            out.close();
        }
        return blob;
    }
}

