/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.GetParent", category="Document", label="Get Parent", description="Get the parent document of the input document. The parent document will become the input for the next operation. You can use the 'type' parameter to specify which parent to select from the document ancestors")
public class GetDocumentParent {
    public static final String ID = "Document.GetParent";
    @Context
    protected CoreSession session;
    @Param(name="type", required=false)
    protected String type;

    @OperationMethod
    public DocumentModel run(DocumentRef doc) throws Exception {
        if (this.type == null) {
            return this.session.getParentDocument(doc);
        }
        this.type = this.type.trim();
        if (this.type.length() == 0) {
            return this.session.getParentDocument(doc);
        }
        DocumentModel parent = this.session.getParentDocument(doc);
        while (parent != null && !this.type.equals(parent.getType())) {
            parent = this.session.getParentDocument(parent.getRef());
        }
        return parent;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc.getRef()));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }
}

