/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.SetACE", category="Document", label="Set ACL", description="Set Acces Control Entry on the input document(s). Returns the document(s).")
public class SetDocumentACE {
    public static final String ID = "Document.SetACE";
    @Context
    protected CoreSession session;
    @Param(name="user")
    protected String user;
    @Param(name="permission")
    String permission;
    @Param(name="acl", required=false, values={"local"})
    String aclName = "local";
    @Param(name="grant", required=false, values={"true"})
    boolean grant = true;
    @Param(name="overwrite", required=false, values={"true"})
    boolean overwrite = true;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.setACE(doc.getRef());
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod
    public DocumentRef run(DocumentRef doc) throws Exception {
        this.setACE(doc);
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }

    @OperationMethod
    public DocumentModelList run(DocumentRefList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl((int)docs.totalSize());
        for (DocumentRef doc : docs) {
            result.add((Object)this.session.getDocument(this.run(doc)));
        }
        return result;
    }

    protected void setACE(DocumentRef ref) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl(this.aclName);
        acp.addACL((ACL)acl);
        ACE ace = new ACE(this.user, this.permission, this.grant);
        acl.add((Object)ace);
        this.session.setACP(ref, (ACP)acp, false);
    }
}

