/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.notification;

import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.mail.Composer;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Notification.SendMail", category="Notification", label="Send E-Mail", description="Send an email using the input document to the specified recipients.")
public class SendMail {
    public static final Composer COMPOSER = new Composer();
    public static final String ID = "Notification.SendMail";
    @Context
    protected OperationContext ctx;
    @Param(name="message", widget="TextArea")
    protected String message;
    @Param(name="subject")
    protected String subject;
    @Param(name="from")
    protected String from;
    @Param(name="to")
    protected StringList to;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.send(this.getRecipients());
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        this.send(this.getRecipients());
        return docs;
    }

    protected StringList getRecipients() {
        return this.to;
    }

    protected void send(StringList sendTo) throws Exception {
        Map<String, Object> map = Scripting.initBindings(this.ctx);
        Mailer.Message msg = COMPOSER.newTextMessage(this.message, map);
        msg.setFrom(this.from);
        msg.setSubject(this.subject);
        for (String r : sendTo) {
            msg.addTo(r);
        }
        msg.send();
    }
}

