/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import net.sf.json.JSONObject;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentRefListImpl;

@Provider
@Consumes(value={"application/json+nxrequest"})
public class JsonRequestReader
implements MessageBodyReader<ExecutionRequest> {
    public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return ExecutionRequest.class.isAssignableFrom(arg0);
    }

    public ExecutionRequest readFrom(Class<ExecutionRequest> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream in) throws IOException, WebApplicationException {
        return JsonRequestReader.readRequest(in);
    }

    public static ExecutionRequest readRequest(InputStream in) throws IOException {
        String value;
        Iterator it;
        String content = FileUtils.read((InputStream)in);
        JSONObject json = JSONObject.fromObject((Object)content);
        String input = json.optString("input", null);
        JSONObject jsonParams = json.optJSONObject("params");
        JSONObject jsonContext = json.optJSONObject("context");
        DocumentRef inObj = null;
        if (input != null) {
            if (input.startsWith("doc:")) {
                inObj = JsonRequestReader.docRefFromString(input.substring(4).trim());
            } else if (input.startsWith("docs:")) {
                String[] ar = StringUtils.split((String)input.substring(5).trim(), (char)',', (boolean)true);
                DocumentRefListImpl list = new DocumentRefListImpl(ar.length);
                for (int i = 0; i < ar.length; ++i) {
                    list.add((Object)JsonRequestReader.docRefFromString(ar[i]));
                }
                inObj = list;
            }
        }
        ExecutionRequest req = new ExecutionRequest(inObj);
        if (jsonParams != null) {
            it = jsonParams.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                value = jsonParams.getString(key);
                req.setParam(key, value);
            }
        }
        if (jsonContext != null) {
            it = jsonContext.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                value = jsonParams.getString(key);
                req.setContextParam(key, value);
            }
        }
        return req;
    }

    public static DocumentRef docRefFromString(String input) {
        if (input.startsWith("/")) {
            return new PathRef(input);
        }
        return new IdRef(input);
    }
}

