/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.cache.aop.CachedAttribute;
import org.jboss.cache.aop.annotation.Serializable;
import org.jboss.cache.aop.annotation.Transient;
import org.jboss.cache.aop.references.FieldPersistentReference;

public class CachedType {
    protected static final Set immediates = new HashSet<Object>(Arrays.asList(String.class, Boolean.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Character.class, Boolean.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Character.TYPE, Class.class));
    protected WeakReference type;
    protected boolean immutable;
    protected boolean immediate;
    protected static Map CachedClassWithNoAnnotation_ = new WeakHashMap();
    protected static Map CachedClassWithAnnotation_ = new WeakHashMap();
    protected List fields = new ArrayList();
    protected Map fieldMap = new HashMap();

    public CachedType() {
    }

    public CachedType(Class type) {
        this.type = new WeakReference<Class>(type);
        this.analyze();
    }

    public Class getType() {
        return (Class)this.type.get();
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public static boolean isImmediate(Class clazz) {
        return immediates.contains(clazz);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public List getFields() {
        if (this.fields == null) {
            return null;
        }
        ArrayList result = new ArrayList(this.fields.size());
        Iterator iter = this.getFieldsIterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public Iterator getFieldsIterator() {
        return new FieldsIterator(this);
    }

    public Field getField(String name) {
        FieldPersistentReference ref = (FieldPersistentReference)this.fieldMap.get(name);
        if (ref == null) {
            return null;
        }
        return (Field)ref.get();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType().getName()).append(" {\n");
        sb.append("}, immutable =").append(this.immutable);
        return sb.toString();
    }

    private void analyze() {
        this.analyzeFields(this.getType());
        this.immediate = CachedType.isImmediate(this.getType());
    }

    void analyzeFields(Class clazz) {
        if (clazz == null) {
            return;
        }
        this.analyzeFields(clazz.getSuperclass());
        Field[] classFields = clazz.getDeclaredFields();
        for (int i = 0; i < classFields.length; ++i) {
            Field f = classFields[i];
            if (CachedType.isPrimitiveNonReplicatable(f)) continue;
            f.setAccessible(true);
            FieldPersistentReference persistentRef = new FieldPersistentReference(f, 2);
            this.fields.add(persistentRef);
            this.fieldMap.put(f.getName(), persistentRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean hasAnnotation(Class clazz, Advisor advisor, CachedType type) {
        if (CachedClassWithNoAnnotation_.get(clazz) != null) {
            return false;
        }
        if (CachedClassWithAnnotation_.get(clazz) != null) {
            return true;
        }
        Iterator i = type.getFieldsIterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            if (!CachedType.hasFieldAnnotation(field, advisor)) continue;
            Map map = CachedClassWithAnnotation_;
            synchronized (map) {
                CachedClassWithAnnotation_.put(clazz, clazz.getName());
            }
            return true;
        }
        Map map = CachedClassWithNoAnnotation_;
        synchronized (map) {
            CachedClassWithNoAnnotation_.put(clazz, clazz.getName());
        }
        return false;
    }

    protected static boolean isPrimitiveNonReplicatable(Field f) {
        int mods = f.getModifiers();
        return Modifier.isStatic(mods) || Modifier.isTransient(mods) || Modifier.isFinal(mods);
    }

    protected static boolean hasTransientAnnotation(FieldInvocation invocation) {
        Object obj = invocation.resolveAnnotation(Transient.class);
        return obj != null;
    }

    protected static boolean hasFieldAnnotation(Field field, Advisor advisor) {
        return CachedType.hasTransientAnnotation(field, advisor) || CachedType.hasSerializableAnnotation(field, advisor);
    }

    protected static boolean hasTransientAnnotation(Field field, Advisor advisor) {
        Object obj = advisor.resolveAnnotation(field, Transient.class);
        return obj != null;
    }

    public static boolean hasSerializableAnnotation(Field field, Advisor advisor) {
        Object obj = advisor.resolveAnnotation(field, Serializable.class);
        return obj != null;
    }

    public static boolean hasSerializableAnnotation(FieldInvocation invocation) {
        Object obj = invocation.resolveAnnotation(Serializable.class);
        return obj != null;
    }

    public static boolean isNonReplicatable(FieldInvocation fieldInvocation) {
        return CachedType.hasTransientAnnotation(fieldInvocation) || CachedType.isPrimitiveNonReplicatable(fieldInvocation.getField());
    }

    protected String attributeName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    protected CachedAttribute getAttribute(Method method, Map map, boolean create) {
        String name = this.attributeName(method.getName());
        CachedAttribute attribute = (CachedAttribute)map.get(name);
        if (create && attribute == null) {
            attribute = new CachedAttribute(name);
            map.put(name, attribute);
        }
        return attribute;
    }

    protected boolean isGet(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    protected boolean isSet(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    private class FieldsIterator
    implements Iterator {
        private Iterator source;
        private Class clazz;

        FieldsIterator(CachedType type) {
            this.clazz = type.getType();
            if (this.clazz == null) {
                throw new RuntimeException("Class was already unloaded");
            }
            this.source = type.fields.iterator();
        }

        public boolean hasNext() {
            return this.source.hasNext();
        }

        public Object next() {
            FieldPersistentReference ref = (FieldPersistentReference)this.source.next();
            return ref == null ? null : ref.get();
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a field from a CachedType");
        }
    }
}

