/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.PassivationInterceptorMBean;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public class PassivationInterceptor
extends Interceptor
implements PassivationInterceptorMBean {
    protected CacheLoader loader = null;
    private SynchronizedLong m_passivations = new SynchronizedLong(0L);

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        Object[] args = m.getArgs();
        if (m.getMethodId() == 8) {
            Fqn fqn = (Fqn)args[0];
            PassivationInterceptor passivationInterceptor = this;
            synchronized (passivationInterceptor) {
                Map attributes = this.getNodeAttributes(fqn);
                if (attributes != null) {
                    attributes.remove("jboss:internal:uninitialized");
                }
                this.cache.notifyNodePassivate(fqn, true);
                this.loader.put(fqn, attributes);
            }
            if (this.statsEnabled && this.cache.getUseInterceptorMbeans()) {
                this.m_passivations.increment();
            }
        }
        return super.invoke(m);
    }

    public long getPassivations() {
        return this.m_passivations.get();
    }

    public void resetStatistics() {
        this.m_passivations.set(0L);
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("Passivations", new Long(this.m_passivations.get()));
        return retval;
    }

    private Map getNodeAttributes(Fqn fqn) {
        if (fqn == null) {
            return null;
        }
        TreeNode n = this.cache.getRoot();
        int size = fqn.size();
        for (int i = 0; i < size && n != null; n = n.getChild(fqn.get(i)), ++i) {
        }
        if (n != null) {
            return n.getData();
        }
        return null;
    }
}

