/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.name.DefaultStringNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.nuxeo.ecm.directory.DirectoryException;

public class LDAPFilterMatcher {
    private final FilterParser parser = new FilterParserImpl();
    private Normalizer normalizer;

    LDAPFilterMatcher() {
    }

    public boolean match(Attributes attributes, String filter) throws DirectoryException {
        try {
            ExprNode parsedFilter = this.parser.parse(filter);
            return this.recursiveMatch(attributes, parsedFilter);
        }
        catch (Exception e) {
            throw new DirectoryException("could not parse LDAP filter: " + filter, (Throwable)e);
        }
    }

    private boolean recursiveMatch(Attributes attributes, ExprNode filterElement) throws DirectoryException {
        if (filterElement instanceof PresenceNode) {
            return this.presenceMatch(attributes, (PresenceNode)filterElement);
        }
        if (filterElement instanceof SimpleNode) {
            return LDAPFilterMatcher.simpleMatch(attributes, (SimpleNode)filterElement);
        }
        if (filterElement instanceof SubstringNode) {
            return this.substringMatch(attributes, (SubstringNode)filterElement);
        }
        if (filterElement instanceof BranchNode) {
            return this.branchMatch(attributes, (BranchNode)filterElement);
        }
        throw new DirectoryException("unsupported filter element type: " + filterElement.toString());
    }

    private boolean presenceMatch(Attributes attributes, PresenceNode presenceElement) {
        return attributes.get(presenceElement.getAttribute()) != null;
    }

    private static boolean simpleMatch(Attributes attributes, SimpleNode simpleElement) throws DirectoryException {
        Attribute attribute = attributes.get(simpleElement.getAttribute());
        if (attribute == null) {
            return false;
        }
        try {
            NamingEnumeration<?> rawValues = attribute.getAll();
            while (rawValues.hasMore()) {
                String rawValue = rawValues.next().toString();
                if (!simpleElement.getValue().equals(rawValue)) continue;
                return true;
            }
        }
        catch (NamingException e) {
            throw new DirectoryException("could not retrieve value for attribute: " + simpleElement.getAttribute());
        }
        return false;
    }

    private boolean substringMatch(Attributes attributes, SubstringNode substringElement) throws DirectoryException {
        try {
            Attribute attribute = attributes.get(substringElement.getAttribute());
            if (attribute == null) {
                return false;
            }
            NamingEnumeration<?> rawValues = attribute.getAll();
            while (rawValues.hasMore()) {
                Pattern pattern;
                String rawValue = rawValues.next().toString();
                Normalizer normalizer = this.getNormalizer();
                try {
                    pattern = substringElement.getRegex(normalizer);
                }
                catch (Exception e) {
                    throw new DirectoryException("could not build regexp for substring: " + substringElement.toString());
                }
                if (!pattern.matcher(rawValue).matches()) continue;
                return true;
            }
            return false;
        }
        catch (NamingException e1) {
            throw new DirectoryException("could not retrieve value for attribute: " + substringElement.getAttribute());
        }
    }

    private Normalizer getNormalizer() {
        if (this.normalizer == null) {
            this.normalizer = new DefaultStringNormalizer();
        }
        return this.normalizer;
    }

    private boolean branchMatch(Attributes attributes, BranchNode branchElement) throws DirectoryException {
        if (branchElement.isConjunction()) {
            for (ExprNode child : branchElement.getChildren()) {
                if (this.recursiveMatch(attributes, child)) continue;
                return false;
            }
            return true;
        }
        if (branchElement.isDisjunction()) {
            for (ExprNode child : branchElement.getChildren()) {
                if (!this.recursiveMatch(attributes, child)) continue;
                return true;
            }
            return false;
        }
        if (branchElement.isNegation()) {
            return !this.recursiveMatch(attributes, branchElement.getChild());
        }
        throw new DirectoryException("unsupported branching filter element type: " + branchElement.toString());
    }
}

