/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.wss.backend.NuxeoWSSBackend;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.spi.AbstractWSSBackend;

public abstract class AbstractNuxeoCoreBackend
extends AbstractWSSBackend
implements NuxeoWSSBackend {
    protected CoreSession session;

    protected CoreSession getCoreSession() throws Exception {
        if (this.session == null) {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            this.session = rm.getDefaultRepository().open();
        }
        return this.session;
    }

    protected void close() {
        if (this.session != null) {
            CoreInstance.getInstance().close(this.session);
            this.session = null;
        }
    }

    public void discardChanges() throws WSSException {
        this.discardChanges(true);
    }

    @Override
    public void discardChanges(boolean release) throws WSSException {
        if (this.session != null) {
            try {
                this.session.cancel();
                if (release) {
                    this.close();
                }
            }
            catch (Exception e) {
                throw new WSSException("Error during discard", (Throwable)e);
            }
        }
    }

    public void saveChanges() throws WSSException {
        this.saveChanges(true);
    }

    @Override
    public void saveChanges(boolean release) throws WSSException {
        if (this.session != null) {
            try {
                this.session.save();
                if (release) {
                    this.close();
                }
            }
            catch (ClientException e) {
                throw new WSSException("Error during save", (Throwable)e);
            }
        }
    }
}

