/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.wss.backend.AbstractNuxeoCoreBackend;
import org.nuxeo.ecm.platform.wss.backend.NuxeoListItem;
import org.nuxeo.ecm.platform.wss.backend.NuxeoTask;
import org.nuxeo.ecm.platform.wss.backend.TranslationHelper;
import org.nuxeo.ecm.platform.wss.service.WSSPlugableBackendManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.DWSMetaDataImpl;
import org.nuxeo.wss.spi.dws.Link;
import org.nuxeo.wss.spi.dws.LinkImpl;
import org.nuxeo.wss.spi.dws.Site;
import org.nuxeo.wss.spi.dws.SiteImpl;
import org.nuxeo.wss.spi.dws.Task;
import org.nuxeo.wss.spi.dws.User;
import org.nuxeo.wss.spi.dws.UserImpl;

public class SimpleNuxeoBackend
extends AbstractNuxeoCoreBackend
implements WSSBackend {
    private static final Log log = LogFactory.getLog(SimpleNuxeoBackend.class);
    protected String corePathPrefix;
    protected String urlRoot;

    public SimpleNuxeoBackend(String corePathPrefix, String urlRoot) {
        this.corePathPrefix = corePathPrefix;
        this.urlRoot = urlRoot;
    }

    public SimpleNuxeoBackend(String corePathPrefix, String urlRoot, CoreSession session) {
        this(corePathPrefix, urlRoot);
        this.session = session;
    }

    protected DocumentModel resolveLocation(String location) throws ClientException, WSSException, Exception {
        Path strPath = new Path(this.corePathPrefix);
        strPath = strPath.append(location);
        PathRef docRef = new PathRef(strPath.toString());
        DocumentModel doc = null;
        if (this.getCoreSession().exists((DocumentRef)docRef)) {
            doc = this.getCoreSession().getDocument((DocumentRef)docRef);
        } else {
            Path path = new Path(location);
            String parentSubPath = path.removeLastSegments(1).toString();
            Path parentPath = new Path(this.corePathPrefix);
            String filename = path.lastSegment();
            String folderName = filename.replace(" ", "-");
            PathRef folderRef = new PathRef(parentPath.append(folderName).toString());
            if (this.getCoreSession().exists((DocumentRef)folderRef)) {
                return this.getCoreSession().getDocument((DocumentRef)folderRef);
            }
            parentPath = parentPath.append(parentSubPath);
            docRef = new PathRef(parentPath.toString());
            if (!this.getCoreSession().exists((DocumentRef)docRef)) {
                throw new WSSException("Unable to find parent for item " + location);
            }
            DocumentModelList children = this.getCoreSession().getChildren((DocumentRef)docRef);
            for (DocumentModel child : children) {
                BlobHolder bh = (BlobHolder)child.getAdapter(BlobHolder.class);
                if (bh == null) continue;
                Blob blob = bh.getBlob();
                if (blob != null && filename.equals(blob.getFilename())) {
                    doc = child;
                    break;
                }
                if (blob == null || !URLEncoder.encode(filename).equals(blob.getFilename())) continue;
                doc = child;
                break;
            }
        }
        return doc;
    }

    public boolean exists(String location) {
        return super.exists(location);
    }

    public WSSListItem getItem(String location) throws WSSException {
        try {
            DocumentModel doc = this.resolveLocation(location);
            if (doc != null) {
                return WSSPlugableBackendManager.instance().createItem(doc, this.corePathPrefix, this.urlRoot);
            }
            throw new WSSException("Unable to find item " + location);
        }
        catch (Exception e) {
            throw new WSSException("Error while getting item", (Throwable)e);
        }
    }

    public List<WSSListItem> listItems(String location) throws WSSException {
        Path strPath = new Path(this.corePathPrefix);
        strPath = strPath.append(location);
        PathRef docRef = new PathRef(strPath.toString());
        ArrayList<WSSListItem> items = new ArrayList<WSSListItem>();
        try {
            if (!this.getCoreSession().exists((DocumentRef)docRef)) {
                throw new WSSException("Unable to find item " + location);
            }
            DocumentModelList children = this.getCoreSession().getChildren((DocumentRef)docRef);
            for (DocumentModel child : children) {
                if (child.hasFacet("HiddenInNavigation")) {
                    log.debug((Object)"Skipping hidden doc");
                    continue;
                }
                if ("deleted".equals(child.getCurrentLifeCycleState())) {
                    log.debug((Object)"Skipping deleted doc");
                    continue;
                }
                items.add(WSSPlugableBackendManager.instance().createItem(child, this.corePathPrefix, this.urlRoot));
            }
            return items;
        }
        catch (Exception e) {
            throw new WSSException("Error while getting children for " + location, (Throwable)e);
        }
    }

    public WSSListItem moveDocument(DocumentModel source, String newLocation) throws WSSException {
        Path destinationPath = new Path(this.corePathPrefix);
        destinationPath = destinationPath.append(newLocation);
        String name = source.getName();
        PathRef targetRef = new PathRef(destinationPath.removeLastSegments(1).toString());
        DocumentModel movedDoc = null;
        try {
            movedDoc = this.getCoreSession().move(source.getRef(), (DocumentRef)targetRef, name);
        }
        catch (Exception e) {
            log.error((Object)("Error while moving " + source.getPathAsString() + " to " + newLocation), (Throwable)e);
            throw new WSSException("Error while moving " + source.getPathAsString() + " to " + newLocation, (Throwable)e);
        }
        if (movedDoc != null) {
            return WSSPlugableBackendManager.instance().createItem(movedDoc, this.corePathPrefix, this.urlRoot);
        }
        throw new WSSException("No resulting doc found !!!");
    }

    public WSSListItem moveItem(String oldLocation, String newLocation) throws WSSException {
        Path sourcePath = new Path(this.corePathPrefix);
        sourcePath = sourcePath.append(oldLocation);
        Path destinationPath = new Path(this.corePathPrefix);
        destinationPath = destinationPath.append(newLocation);
        DocumentModel movedDoc = null;
        try {
            if (sourcePath.removeLastSegments(1).toString().equals(destinationPath.removeLastSegments(1).toString())) {
                DocumentModel source = this.resolveLocation(oldLocation);
                String dstName = destinationPath.lastSegment();
                if (source.isFolder()) {
                    source.setPropertyValue("dc:title", (Serializable)((Object)dstName));
                    this.getCoreSession().saveDocument(source);
                    movedDoc = this.getCoreSession().move(source.getRef(), source.getParentRef(), this.cleanName(dstName));
                } else {
                    Blob blob;
                    BlobHolder bh = (BlobHolder)source.getAdapter(BlobHolder.class);
                    boolean blobUpdated = false;
                    if (bh != null && (blob = bh.getBlob()) != null) {
                        blob.setFilename(dstName);
                        blobUpdated = true;
                        if (source.hasSchema("file")) {
                            source.setProperty("file", "content", (Object)blob);
                        }
                        movedDoc = this.getCoreSession().saveDocument(source);
                    }
                    if (!blobUpdated) {
                        source.setPropertyValue("dc:title", (Serializable)((Object)dstName));
                        source = this.getCoreSession().saveDocument(source);
                        movedDoc = this.getCoreSession().move(source.getRef(), source.getParentRef(), this.cleanName(dstName));
                    }
                }
            } else {
                DocumentModel source = this.resolveLocation(oldLocation);
                String name = source.getName();
                PathRef targetRef = new PathRef(destinationPath.removeLastSegments(1).toString());
                movedDoc = this.getCoreSession().move(source.getRef(), (DocumentRef)targetRef, name);
            }
        }
        catch (Exception e) {
            throw new WSSException("Error while doing move", (Throwable)e);
        }
        if (movedDoc != null) {
            return WSSPlugableBackendManager.instance().createItem(movedDoc, this.corePathPrefix, this.urlRoot);
        }
        throw new WSSException("No resulting doc found !!!");
    }

    public void removeItem(String location) throws WSSException {
        DocumentModel docToRemove = null;
        try {
            docToRemove = this.resolveLocation(location);
        }
        catch (Exception e) {
            throw new WSSException("Error while resolving document path", (Throwable)e);
        }
        if (docToRemove == null) {
            throw new WSSException("Document path not found");
        }
        try {
            this.getCoreSession().removeDocument(docToRemove.getRef());
        }
        catch (Exception e) {
            throw new WSSException("Error while deleting doc " + docToRemove.getRef(), (Throwable)e);
        }
    }

    protected DocumentModel createNode(String parentPath, String name, boolean folderish) throws WSSException {
        DocumentModel parent;
        try {
            parent = this.resolveLocation(parentPath);
        }
        catch (Exception e) {
            throw new WSSException("Error while resolving parent path", (Throwable)e);
        }
        if (parent == null) {
            throw new WSSException("Error while resolving parent path");
        }
        if (!parent.isFolder()) {
            throw new WSSException("Can not create a child in a non folderish node");
        }
        String targetType = WSSPlugableBackendManager.folderishDocType;
        if (folderish) {
            if ("WorkspaceRoot".equals(parent.getType())) {
                targetType = "Workspace";
            }
        } else {
            targetType = WSSPlugableBackendManager.leafDocType;
        }
        String nodeName = this.cleanName(name);
        try {
            DocumentModel newDoc = this.getCoreSession().createDocumentModel(parent.getPathAsString(), nodeName, targetType);
            newDoc.setPropertyValue("dc:title", (Serializable)((Object)name));
            newDoc = this.getCoreSession().createDocument(newDoc);
            return newDoc;
        }
        catch (Exception e) {
            throw new WSSException("Error child creating new folder", (Throwable)e);
        }
    }

    public WSSListItem createFolder(String parentPath, String name) throws WSSException {
        DocumentModel newFolder = this.createNode(parentPath, name, true);
        return WSSPlugableBackendManager.instance().createItem(newFolder, this.corePathPrefix, this.urlRoot);
    }

    protected String cleanName(String name) {
        String s = name.replaceAll(" ", "-");
        s = s.replaceAll("[\u00e8\u00e9\u00ea\u00eb]", "e");
        s = s.replaceAll("[\u00fb\u00f9]", "u");
        s = s.replaceAll("[\u00ef\u00ee]", "i");
        s = s.replaceAll("[\u00e0\u00e2]", "a");
        s = s.replaceAll("\u00d4", "o");
        s = s.replaceAll("\u00e7", "c");
        s = s.replaceAll("[\u00c8\u00c9\u00ca\u00cb]", "E");
        s = s.replaceAll("[\u00db\u00d9]", "U");
        s = s.replaceAll("[\u00cf\u00ce]", "I");
        s = s.replaceAll("[\u00c0\u00c2]", "A");
        s = s.replaceAll("\u00d4", "O");
        s = s.replaceAll("\u00c7", "C");
        return s;
    }

    public WSSListItem createFileItem(String parentPath, String name) throws WSSException {
        DocumentModel newFolder = this.createNode(parentPath, name, false);
        return WSSPlugableBackendManager.instance().createItem(newFolder, this.corePathPrefix, this.urlRoot);
    }

    public Site getSite(String location) throws WSSException {
        String parentPath = new Path(location).removeLastSegments(1).toString();
        NuxeoListItem parent = (NuxeoListItem)this.getItem(parentPath);
        String siteName = parent.getDisplayName();
        SiteImpl site = new SiteImpl(siteName);
        String nxUrl = "nuxeo/nxpath/default" + parent.getDoc().getPathAsString() + "@view_documents";
        try {
            site.setAccessUrl("?org.nuxeo.wss.forwardedFilter=" + URLEncoder.encode(nxUrl, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WSSException("Error encoding url", (Throwable)e);
        }
        site.setUserManagementUrl("");
        site.setListUUID(parent.getEtag());
        site.setItem((WSSListItem)parent);
        return site;
    }

    public DWSMetaData getMetaData(String location, WSSRequest request) throws WSSException {
        try {
            DWSMetaDataImpl metadata = new DWSMetaDataImpl();
            String parentPath = new Path(location).removeLastSegments(1).toString();
            List<WSSListItem> documents = this.listItems(parentPath);
            NuxeoListItem doc = (NuxeoListItem)this.getItem(location);
            metadata.setDocuments(documents);
            metadata.setSite(this.getSite(location));
            String cUserName = this.getCoreSession().getPrincipal().getName();
            ArrayList<String> userNames = new ArrayList<String>();
            for (WSSListItem item : documents) {
                String[] contributors;
                if (!userNames.contains(item.getAuthor())) {
                    userNames.add(item.getAuthor());
                }
                if ((contributors = (String[])((NuxeoListItem)item).getDoc().getPropertyValue("dc:contributors")) == null) continue;
                for (String contributor : contributors) {
                    if (userNames.contains(contributor)) continue;
                    userNames.add(contributor);
                }
            }
            User currentUser = this.getUserFromLogin(cUserName, 1);
            metadata.setCurrentUser(currentUser);
            List<Link> links = this.getDocumentLinks(doc.getDoc(), userNames, request);
            metadata.setLinks(links);
            List<Task> tasks = this.getTasks(doc.getDoc(), userNames, request);
            metadata.setTasks(tasks);
            ArrayList<User> users = new ArrayList<User>();
            users.add(currentUser);
            int i = 2;
            for (String name : userNames) {
                if (name.equals(cUserName)) continue;
                users.add(this.getUserFromLogin(name, i));
                ++i;
            }
            metadata.setUsers(users);
            return metadata;
        }
        catch (Exception e) {
            throw new WSSException("Error in getMetadata", (Throwable)e);
        }
    }

    protected List<Task> getTasks(DocumentModel doc, List<String> userNames, WSSRequest request) throws Exception {
        ArrayList<Task> tasks = new ArrayList<Task>();
        JbpmService jbpmService = (JbpmService)Framework.getService(JbpmService.class);
        List jbpmTasks = jbpmService.getTaskInstances(doc, null, (JbpmListFilter)null);
        for (TaskInstance jbpmTask : jbpmTasks) {
            String assignee;
            String editor;
            NuxeoTask task = new NuxeoTask(jbpmTask, "");
            task.translateDirective(request);
            tasks.add(task);
            String author = task.getAuthorLogin();
            if (author != null && !userNames.contains(author)) {
                userNames.add(author);
            }
            if ((editor = task.getEditorLogin()) != null && !userNames.contains(editor)) {
                userNames.add(editor);
            }
            if ((assignee = task.getAssigneeLogin()) == null || userNames.contains(assignee)) continue;
            userNames.add(assignee);
        }
        return tasks;
    }

    protected List<Link> getDocumentLinks(DocumentModel doc, List<String> userNames, WSSRequest request) throws Exception {
        ArrayList<Link> links = new ArrayList<Link>();
        RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
        QNameResource documentResource = (QNameResource)relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)doc, null);
        StatementImpl pattern = new StatementImpl(null, null, (Node)documentResource);
        List inStatements = relationManager.getStatements("default", (Statement)pattern);
        links.addAll(this.computeLinks(inStatements, userNames, true, request));
        pattern = new StatementImpl((Node)documentResource, null, null);
        List outStatements = relationManager.getStatements("default", (Statement)pattern);
        links.addAll(this.computeLinks(outStatements, userNames, false, request));
        return links;
    }

    protected List<Link> computeLinks(List<Statement> statements, List<String> userNames, boolean incomming, WSSRequest request) throws Exception {
        ArrayList<Link> links = new ArrayList<Link>();
        int counter = 1;
        String baseUrl = request.getBaseUrl();
        String targetDocTitle = "";
        for (Statement stmt : statements) {
            String author;
            String url = "";
            if (incomming) {
                Subject subject = stmt.getSubject();
                if (subject.isLiteral()) {
                    url = ((Literal)subject).getValue();
                } else if (subject.isQNameResource()) {
                    if ("http://www.nuxeo.org/document/uid/".equals(((QNameResource)subject).getNamespace())) {
                        url = this.mkDocLink(baseUrl, ((QNameResource)subject).getLocalName());
                        targetDocTitle = this.getDocTitle(((QNameResource)subject).getLocalName());
                    } else {
                        url = ((QNameResource)subject).getUri();
                    }
                } else if (subject.isResource()) {
                    url = ((Resource)subject).getUri();
                }
            } else {
                Node object = stmt.getObject();
                if (object.isLiteral()) {
                    url = ((Literal)object).getValue();
                } else if (object.isQNameResource()) {
                    if ("http://www.nuxeo.org/document/uid/".equals(((QNameResource)object).getNamespace())) {
                        url = this.mkDocLink(baseUrl, ((QNameResource)object).getLocalName());
                        targetDocTitle = this.getDocTitle(((QNameResource)object).getLocalName());
                    } else {
                        url = ((QNameResource)object).getUri();
                    }
                } else if (object.isResource()) {
                    url = ((Resource)object).getUri();
                }
            }
            String comment = "";
            Node node = stmt.getProperty(RelationConstants.COMMENT);
            if (node != null && node.isLiteral()) {
                comment = ((Literal)node).getValue();
            }
            Date creationDate = null;
            Node dateNode = stmt.getProperty(RelationConstants.CREATION_DATE);
            if (dateNode != null && dateNode.isLiteral()) {
                creationDate = RelationDate.getDate((Literal)((Literal)dateNode));
            }
            dateNode = stmt.getProperty(RelationConstants.MODIFICATION_DATE);
            Date modificationDate = null;
            if (dateNode != null && dateNode.isLiteral()) {
                modificationDate = RelationDate.getDate((Literal)((Literal)dateNode));
            }
            if ((author = (node = stmt.getProperty(RelationConstants.AUTHOR)) != null && node.isLiteral() ? ((Literal)node).getValue() : "") != null && !userNames.contains(author)) {
                userNames.add(author);
            }
            String predicateURL = stmt.getPredicate().getUri();
            String predicate = new Path(predicateURL).lastSegment();
            String labelKey = "label.relation.predicate." + predicate;
            String predicateLabel = TranslationHelper.getLabel(labelKey, request);
            comment = predicateLabel + "\n" + targetDocTitle + "\n" + comment;
            String id = "";
            id = incomming ? "1" + counter : "2" + counter;
            LinkImpl link = new LinkImpl(id, author, creationDate, modificationDate, "", comment, url);
            links.add((Link)link);
            ++counter;
        }
        return links;
    }

    protected String mkDocLink(String baseURL, String uri) {
        return baseURL + "nuxeo/nxdoc/" + uri + "/view_documents";
    }

    protected String getDocTitle(String uri) {
        String uuid = uri.split("/")[1];
        IdRef ref = new IdRef(uuid);
        try {
            if (this.getCoreSession().exists((DocumentRef)ref)) {
                return this.getCoreSession().getDocument((DocumentRef)ref).getTitle();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    protected User getUserFromLogin(String userLogin, int idx) throws Exception {
        UserImpl user = null;
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal principal = um.getPrincipal(userLogin);
        if (principal != null) {
            String email = (String)principal.getModel().getProperty(um.getUserSchemaName(), um.getUserEmailField());
            String fullname = principal.getFirstName() + " " + principal.getLastName();
            if (fullname.equals(" ")) {
                fullname = userLogin;
            }
            user = new UserImpl("" + idx, userLogin, fullname, email);
        } else {
            user = new UserImpl("" + idx, userLogin, userLogin, "");
        }
        return user;
    }
}

