/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.io.Serializable;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Validator;
import org.nuxeo.ecm.webengine.model.WebContext;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static DocumentModel createDocument(WebContext context, DocumentModel parent, String name) {
        try {
            Module module;
            Validator v;
            CoreSession session = context.getCoreSession();
            FormData form = context.getForm();
            String type = form.getDocumentType();
            if (type == null) {
                throw new WebException("Invalid argument exception. Nos doc type specified");
            }
            String path = parent.getPathAsString();
            if (name == null) {
                name = form.getDocumentTitle();
                name = name == null ? IdUtils.generateId((String)type) : IdUtils.generateId((String)name);
                String baseTitle = name;
                int i = 0;
                try {
                    while (true) {
                        if (i == 10) {
                            throw new WebException("Failed to create document. Giving up.");
                        }
                        session.getDocument((DocumentRef)new PathRef(path, name));
                        name = baseTitle + "_" + Long.toHexString(IdUtils.generateLongId());
                        ++i;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            DocumentModel newDoc = session.createDocumentModel(parent.getPathAsString(), name, type);
            form.fillDocument(newDoc);
            if (newDoc.getTitle().length() == 0) {
                newDoc.getPart("dublincore").get("title").setValue((Object)newDoc.getName());
            }
            if ((v = (module = context.getModule()).getValidator(newDoc.getType())) != null) {
                newDoc = v.validate(newDoc);
            }
            newDoc = session.createDocument(newDoc);
            session.save();
            return newDoc;
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to create document: " + name), (Throwable)e);
        }
    }

    public static DocumentModel updateDocument(WebContext ctx, DocumentModel doc) {
        try {
            ScopedMap ctxData;
            FormData form = ctx.getForm();
            form.fillDocument(doc);
            VersioningActions va = form.getVersioningOption();
            if (va != null) {
                ctxData = doc.getContextData();
                ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.TRUE);
                ctxData.putScopedValue(ScopeType.REQUEST, "VersioningOption", (Serializable)va);
            } else {
                ctxData = doc.getContextData();
                ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.FALSE);
            }
            Module module = ctx.getModule();
            Validator v = module.getValidator(doc.getType());
            if (v != null) {
                doc = v.validate(doc);
            }
            doc = ctx.getCoreSession().saveDocument(doc);
            ctx.getCoreSession().save();
            return doc;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to update document", (Throwable)e);
        }
    }
}

