/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.io.Serializable;
import java.util.HashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="file", type="FileService", targetType="Document")
public class FileService
extends DefaultAdapter {
    @GET
    public Response doGet() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        String xpath = form.getString("property");
        if (xpath == null) {
            if (doc.hasSchema("file")) {
                xpath = "file:content";
            } else {
                throw new IllegalParameterException("Missing request parameter named 'property' that specify the blob property xpath to fetch");
            }
        }
        try {
            Property p = doc.getProperty(xpath);
            Blob blob = (Blob)p.getValue();
            if (blob == null) {
                throw new WebResourceNotFoundException("No attached file at " + xpath);
            }
            String fileName = blob.getFilename();
            if (fileName == null && (p = p.getParent()).isComplex()) {
                try {
                    fileName = (String)((Object)p.getValue("filename"));
                }
                catch (PropertyException e) {
                    fileName = "Unknown";
                }
            }
            return Response.ok((Object)blob).header("Content-Disposition", (Object)("attachment;filename=" + fileName)).type(blob.getMimeType()).build();
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
        }
    }

    @POST
    public Response doPost() {
        Blob blob;
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        form.fillDocument(doc);
        String xpath = this.ctx.getForm().getString("property");
        if (xpath == null) {
            if (doc.hasSchema("file")) {
                xpath = "file:content";
            } else if (doc.hasSchema("files")) {
                xpath = "files:files";
            } else {
                throw new IllegalArgumentException("Missing request parameter named 'property' that specifies the blob property xpath to fetch");
            }
        }
        if ((blob = form.getFirstBlob()) == null) {
            throw new IllegalArgumentException("Could not find any uploaded file");
        }
        try {
            ScopedMap ctxData;
            Property p = doc.getProperty(xpath);
            if (p.isList()) {
                if ("files".equals(p.getSchema().getName())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("filename", blob.getFilename());
                    map.put("file", (Serializable)blob);
                    p.addValue(map);
                } else {
                    p.addValue((Object)blob);
                }
            } else {
                if ("file".equals(p.getSchema().getName())) {
                    p.getParent().get("filename").setValue((Object)blob.getFilename());
                }
                p.setValue((Object)blob);
            }
            VersioningActions va = form.getVersioningOption();
            if (va != null) {
                ctxData = doc.getContextData();
                ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.TRUE);
                ctxData.putScopedValue(ScopeType.REQUEST, "VersioningOption", (Serializable)va);
            } else {
                ctxData = doc.getContextData();
                ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.FALSE);
            }
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(doc);
            session.save();
            return this.redirect(this.getTarget().getPath());
        }
        catch (WebException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
        }
    }

    @GET
    @Path(value="delete")
    public Response remove() {
        return this.doDelete();
    }

    @DELETE
    public Response doDelete() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        String xpath = form.getString("property");
        if (xpath == null) {
            if (doc.hasSchema("file")) {
                xpath = "file:content";
            } else {
                throw new IllegalArgumentException("Missing request parameter named 'property' that specifies the blob property xpath to fetch");
            }
        }
        try {
            doc.getProperty(xpath).remove();
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(doc);
            session.save();
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to delete attached file", (Throwable)e);
        }
        return this.redirect(this.getTarget().getPath());
    }
}

