/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.base;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseObject
implements CMISObject {
    public Map<String, Property> getProperties() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (PropertyDefinition pd : this.getType().getPropertyDefinitions()) {
            String id = pd.getId();
            properties.put(id, this.getProperty(id));
        }
        return properties;
    }

    public void setValue(String id, Serializable value) {
        this.getProperty(id).setValue(value);
    }

    public void setValues(Map<String, Serializable> values) {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    public String getString(String id) {
        return (String)((Object)this.getValue(id));
    }

    public String[] getStrings(String id) {
        return (String[])this.getValue(id);
    }

    public BigDecimal getDecimal(String id) {
        return (BigDecimal)this.getValue(id);
    }

    public BigDecimal[] getDecimals(String id) {
        return (BigDecimal[])this.getValue(id);
    }

    public Integer getInteger(String id) {
        return (Integer)this.getValue(id);
    }

    public Integer[] getIntegers(String id) {
        return (Integer[])this.getValue(id);
    }

    public Boolean getBoolean(String id) {
        return (Boolean)this.getValue(id);
    }

    public Boolean[] getBooleans(String id) {
        return (Boolean[])this.getValue(id);
    }

    public Calendar getDateTime(String id) {
        return (Calendar)this.getValue(id);
    }

    public Calendar[] getDateTimes(String id) {
        return (Calendar[])this.getValue(id);
    }

    public URI getURI(String id) {
        return (URI)this.getValue(id);
    }

    public URI[] getURIs(String id) {
        return (URI[])this.getValue(id);
    }

    public String getId(String id) {
        return (String)((Object)this.getValue(id));
    }

    public String[] getIds(String id) {
        return (String[])this.getValue(id);
    }

    public String getXML(String id) {
        return (String)((Object)this.getValue(id));
    }

    public String[] getXMLs(String id) {
        return (String[])this.getValue(id);
    }

    public String getHTML(String id) {
        return (String)((Object)this.getValue(id));
    }

    public String[] getHTMLs(String id) {
        return (String[])this.getValue(id);
    }

    public String getId() {
        return this.getString("cmis:objectId");
    }

    public String getTypeId() {
        return this.getId("cmis:objectTypeId");
    }

    public String getBaseTypeId() {
        return this.getId("cmis:baseTypeId");
    }

    public String getName() {
        return this.getString("cmis:name");
    }

    public String getCreatedBy() {
        return this.getString("cmis:createdBy");
    }

    public Calendar getCreationDate() {
        return this.getDateTime("cmis:creationDate");
    }

    public String getLastModifiedBy() {
        return this.getString("cmis:lastModifiedBy");
    }

    public Calendar getLastModificationDate() {
        return this.getDateTime("cmis:lastModificationDate");
    }

    public String getChangeToken() {
        return this.getString("cmis:changeToken");
    }

    public boolean isImmutable() {
        Boolean b = this.getBoolean("cmis:isImmutable");
        return b == null ? false : b;
    }

    public boolean isLatestVersion() {
        Boolean b = this.getBoolean("cmis:isLatestVersion");
        return b == null ? false : b;
    }

    public boolean isMajorVersion() {
        Boolean b = this.getBoolean("cmis:isMajorVersion");
        return b == null ? false : b;
    }

    public boolean isLatestMajorVersion() {
        Boolean b = this.getBoolean("cmis:isLatestMajorVersion");
        return b == null ? false : b;
    }

    public String getVersionLabel() {
        return this.getString("cmis:versionLabel");
    }

    public String getVersionSeriesId() {
        return this.getId("cmis:versionSeriesId");
    }

    public boolean isVersionSeriesCheckedOut() {
        Boolean b = this.getBoolean("cmis:isVersionSeriesCheckedOut");
        return b == null ? false : b;
    }

    public String getVersionSeriesCheckedOutBy() {
        return this.getString("cmis:versionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return this.getId("cmis:versionSeriesCheckedOutId");
    }

    public String getCheckInComment() {
        return this.getString("cmis:checkinComment");
    }

    public void setName(String value) {
        this.setValue("cmis:name", (Serializable)((Object)value));
    }
}

