/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.chemistry.ACE;
import org.apache.chemistry.ACLPropagation;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.Paging;
import org.apache.chemistry.Policy;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.Rendition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Tree;
import org.apache.chemistry.Type;
import org.apache.chemistry.Unfiling;
import org.apache.chemistry.Updatability;
import org.apache.chemistry.VersioningState;
import org.apache.chemistry.cmissql.CmisSqlLexer;
import org.apache.chemistry.cmissql.CmisSqlParser;
import org.apache.chemistry.impl.simple.CmisSqlSimpleWalker;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleDocument;
import org.apache.chemistry.impl.simple.SimpleFolder;
import org.apache.chemistry.impl.simple.SimpleFulltext;
import org.apache.chemistry.impl.simple.SimpleListPage;
import org.apache.chemistry.impl.simple.SimpleObject;
import org.apache.chemistry.impl.simple.SimpleObjectEntry;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.chemistry.impl.simple.SimplePolicy;
import org.apache.chemistry.impl.simple.SimpleRelationship;
import org.apache.chemistry.impl.simple.SimpleRepository;
import org.apache.chemistry.impl.simple.SimpleTree;
import org.apache.chemistry.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConnection
implements Connection,
SPI {
    protected final SimpleRepository repository;
    protected final SimpleFolder rootFolder;

    public SimpleConnection(SimpleRepository repository) {
        this.repository = repository;
        this.rootFolder = (SimpleFolder)this.getObject(repository.getRootFolderId());
    }

    public Connection getConnection() {
        return this;
    }

    public SPI getSPI() {
        return this;
    }

    public void close() {
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Folder getRootFolder() {
        return this.rootFolder;
    }

    public ObjectId newObjectId(String id) {
        return new SimpleObjectId(id);
    }

    public SimpleObjectEntry newObjectEntry(String typeId) {
        BaseType baseType = this.repository.getType(typeId).getBaseType();
        return new SimpleObjectEntry(new SimpleData(typeId, baseType), this);
    }

    public Document newDocument(String typeId, Folder folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.DOCUMENT) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleObjectEntry entry = this.newObjectEntry(typeId);
        if (folder != null) {
            entry.setValue("cmis:parentId", (Serializable)((Object)folder.getId()));
        }
        return new SimpleDocument(entry, this);
    }

    public Folder newFolder(String typeId, Folder folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleObjectEntry entry = this.newObjectEntry(typeId);
        if (folder != null) {
            entry.setValue("cmis:parentId", (Serializable)((Object)folder.getId()));
        }
        return new SimpleFolder(entry, this);
    }

    public Relationship newRelationship(String typeId) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.RELATIONSHIP) {
            throw new IllegalArgumentException(typeId);
        }
        return new SimpleRelationship(this.newObjectEntry(typeId), this);
    }

    public Policy newPolicy(String typeId, Folder folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.POLICY) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleObjectEntry entry = this.newObjectEntry(typeId);
        if (folder != null) {
            entry.setValue("cmis:parentId", (Serializable)((Object)folder.getId()));
        }
        return new SimplePolicy(entry, this);
    }

    protected List<Tree<ObjectEntry>> getTreeChildren(ObjectId entry, int depth, Inclusion inclusion, String orderBy, BaseType baseType) {
        ArrayList<Tree<ObjectEntry>> children = new ArrayList<Tree<ObjectEntry>>();
        for (ObjectEntry child : this.getChildren(entry, inclusion, orderBy, null)) {
            BaseType childBaseType = child.getBaseType();
            if (baseType != null && baseType != childBaseType) continue;
            List<Tree<ObjectEntry>> c = childBaseType != BaseType.FOLDER || depth == 1 ? null : this.getTreeChildren((ObjectId)child, depth - 1, inclusion, orderBy, baseType);
            children.add(new SimpleTree<ObjectEntry>(child, c));
        }
        return children;
    }

    public Tree<ObjectEntry> getFolderTree(ObjectId folder, int depth, Inclusion inclusion) {
        this.checkFolder(folder);
        return new SimpleTree<Object>(null, this.getTreeChildren(folder, depth, inclusion, null, BaseType.FOLDER));
    }

    public Tree<ObjectEntry> getDescendants(ObjectId folder, int depth, String orderBy, Inclusion inclusion) {
        this.checkFolder(folder);
        return new SimpleTree<Object>(null, this.getTreeChildren(folder, depth, inclusion, orderBy, null));
    }

    public ListPage<ObjectEntry> getChildren(ObjectId folder, Inclusion inclusion, String orderBy, Paging paging) {
        this.checkFolder(folder);
        Set<String> ids = this.repository.children.get(folder.getId());
        ArrayList<ObjectEntry> all = new ArrayList<ObjectEntry>(ids.size());
        for (String id : ids) {
            SimpleData data = this.repository.datas.get(id);
            all.add(new SimpleObjectEntry(data, this));
        }
        return SimpleListPage.fromPaging(all, paging);
    }

    protected void checkFolder(ObjectId object) throws ObjectNotFoundException, ConstraintViolationException {
        String id = object.getId();
        SimpleData data = this.repository.datas.get(id);
        if (data == null) {
            throw new ObjectNotFoundException(id);
        }
        String baseTypeId = (String)data.get("cmis:baseTypeId");
        if (baseTypeId != BaseType.FOLDER.getId()) {
            throw new IllegalArgumentException("Not a folder: " + id);
        }
    }

    public ObjectEntry getFolderParent(ObjectId folder, String filter) {
        String folderId = folder.getId();
        SimpleData data = this.repository.datas.get(folderId);
        if (data == null) {
            throw new RuntimeException("No such folder: " + folder);
        }
        String typeId = (String)data.get("cmis:objectTypeId");
        Type type = this.repository.getType(typeId);
        if (!type.getBaseType().equals((Object)BaseType.FOLDER)) {
            throw new IllegalArgumentException("Not a folder: " + folder);
        }
        Set<String> parents = this.repository.parents.get(folderId);
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        if (parents.size() > 1) {
            throw new ConstraintViolationException(folder + " has " + parents.size() + " parents");
        }
        String parentId = parents.iterator().next();
        return new SimpleObjectEntry(this.repository.datas.get(parentId), this);
    }

    public Collection<ObjectEntry> getObjectParents(ObjectId object, String filter) {
        String objectId = object.getId();
        if (objectId == null) {
            return Collections.emptyList();
        }
        Set<String> ids = this.repository.parents.get(objectId);
        ArrayList<ObjectEntry> parents = new ArrayList<ObjectEntry>(ids.size());
        for (String id : ids) {
            SimpleData data = this.repository.datas.get(id);
            parents.add(new SimpleObjectEntry(data, this));
        }
        return parents;
    }

    public ListPage<ObjectEntry> getCheckedOutDocuments(ObjectId folder, Inclusion inclusion, Paging paging) {
        return SimpleListPage.emptyList();
    }

    protected void saveObject(SimpleObject object) {
        this.saveData(object.entry.data, object.getTypeId());
    }

    protected void saveData(SimpleData data, String typeId) {
        HashMap<String, Object> update = new HashMap<String, Object>();
        String objectId = this.repository.generateId();
        update.put("cmis:objectId", objectId);
        Type type = this.repository.getType(typeId);
        for (PropertyDefinition pd : type.getPropertyDefinitions()) {
            String id = pd.getId();
            if ("cmis:objectId".equals(id) || !pd.isRequired() || data.containsKey(id)) continue;
            if ("cmis:name".equals(id)) {
                update.put("cmis:name", objectId);
                continue;
            }
            if ("cmis:path".equals(id)) {
                update.put("cmis:path", "XXX");
                continue;
            }
            if ("cmis:createdBy".equals(id)) {
                update.put("cmis:createdBy", "system");
                continue;
            }
            if ("cmis:creationDate".equals(id)) {
                update.put("cmis:creationDate", GregorianCalendar.getInstance());
                continue;
            }
            if ("cmis:lastModifiedBy".equals(id)) {
                update.put("cmis:lastModifiedBy", "system");
                continue;
            }
            if ("cmis:lastModificationDate".equals(id)) {
                update.put("cmis:lastModificationDate", GregorianCalendar.getInstance());
                continue;
            }
            if ("cmis:isLatestVersion".equals(id)) {
                update.put("cmis:isLatestVersion", Boolean.TRUE);
                continue;
            }
            if ("cmis:isLatestMajorVersion".equals(id)) {
                update.put("cmis:isLatestMajorVersion", Boolean.TRUE);
                continue;
            }
            if ("cmis:isVersionSeriesCheckedOut".equals(id)) {
                update.put("cmis:isVersionSeriesCheckedOut", Boolean.FALSE);
                continue;
            }
            if ("cmis:versionSeriesId".equals(id)) {
                update.put("cmis:versionSeriesId", objectId);
                continue;
            }
            if ("cmis:versionLabel".equals(id)) {
                update.put("cmis:versionLabel", "1.0");
                continue;
            }
            throw new RuntimeException("Missing property: " + id);
        }
        byte[] bytes = (byte[])data.get("__content__");
        if (type.getContentStreamAllowed() == ContentStreamPresence.REQUIRED && bytes == null) {
            throw new RuntimeException("Content stream required");
        }
        update.put("cmis:contentStreamLength", bytes == null ? null : Integer.valueOf(bytes.length));
        for (String key : update.keySet()) {
            Serializable value = (Serializable)update.get(key);
            if (value == null) {
                data.remove(key);
                continue;
            }
            data.put(key, value);
        }
        this.repository.datas.put(objectId, data);
        String parentId = (String)data.get("cmis:parentId");
        if (type.getBaseType() == BaseType.FOLDER) {
            this.repository.children.put(objectId, this.repository.newSet());
        } else {
            data.remove("cmis:parentId");
        }
        if (parentId != null) {
            Set<String> parents = this.repository.newSet();
            parents.add(parentId);
            this.repository.parents.put(objectId, parents);
            this.repository.children.get(parentId).add(objectId);
        }
    }

    public ObjectId createDocumentFromSource(ObjectId source, ObjectId folder, Map<String, Serializable> properties, VersioningState versioningState) throws NameConstraintViolationException {
        String id = source.getId();
        SimpleData sourceData = this.repository.datas.get(id);
        if (sourceData == null) {
            throw new ObjectNotFoundException(id);
        }
        String typeId = (String)sourceData.get("cmis:objectTypeId");
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.DOCUMENT) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(null, null);
        data.putAll(sourceData);
        if (properties != null) {
            data.putAll(properties);
        }
        data.remove("cmis:creationDate");
        data.remove("cmis:createdBy");
        if (folder == null) {
            data.remove("cmis:parentId");
        } else {
            String folderId = folder.getId();
            if (!this.repository.datas.containsKey(folderId)) {
                throw new ObjectNotFoundException(folderId);
            }
            data.put("cmis:parentId", folderId);
        }
        this.saveData(data, (String)data.get("cmis:objectTypeId"));
        return new SimpleObjectEntry(data, this);
    }

    public ObjectId createDocument(Map<String, Serializable> properties, ObjectId folder, ContentStream contentStream, VersioningState versioningState) {
        Type type;
        String typeId = (String)((Object)properties.get("cmis:objectTypeId"));
        if (typeId == null) {
            typeId = BaseType.DOCUMENT.getId();
            properties.put("cmis:objectTypeId", (Serializable)((Object)typeId));
        }
        if ((type = this.repository.getType(typeId)) == null || type.getBaseType() != BaseType.DOCUMENT) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(typeId, type.getBaseType());
        data.putAll(properties);
        if (contentStream != null) {
            String fn;
            data.put("cmis:contentStreamLength", (int)contentStream.getLength());
            String mt = contentStream.getMimeType();
            if (mt != null) {
                data.put("cmis:contentStreamMimeType", mt);
            }
            if ((fn = contentStream.getFileName()) != null) {
                data.put("cmis:contentStreamFileName", fn);
            }
            try {
                data.put("__content__", SimpleContentStream.getBytes(contentStream.getStream()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (folder != null) {
            data.put("cmis:parentId", folder.getId());
        }
        this.saveData(data, typeId);
        return new SimpleObjectId((String)data.get("cmis:objectId"));
    }

    public ObjectId createFolder(Map<String, Serializable> properties, ObjectId folder) {
        String typeId = (String)((Object)properties.get("cmis:objectTypeId"));
        if (typeId == null) {
            throw new IllegalArgumentException("Missing object type id");
        }
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(typeId, type.getBaseType());
        data.putAll(properties);
        if (folder != null) {
            data.put("cmis:parentId", folder.getId());
        }
        this.saveData(data, typeId);
        return new SimpleObjectId((String)data.get("cmis:objectId"));
    }

    public ObjectId createRelationship(Map<String, Serializable> properties) {
        throw new UnsupportedOperationException();
    }

    public ObjectId createPolicy(Map<String, Serializable> properties, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    public Set<QName> getAllowableActions(ObjectId object) {
        return this.getProperties(object, null).getAllowableActions();
    }

    public ObjectEntry getObject(ObjectId objectId, Inclusion inclusion) {
        return this.getProperties(objectId, inclusion);
    }

    public ObjectEntry getProperties(ObjectId object, Inclusion inclusion) {
        SimpleData data = this.repository.datas.get(object.getId());
        if (data == null) {
            return null;
        }
        return new SimpleObjectEntry(data, this);
    }

    public ObjectEntry getObjectByPath(String path, Inclusion inclusion) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with / : " + path);
        }
        if (!path.equals("/") && path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not end with / : " + path);
        }
        String id = this.repository.getRootFolderId().getId();
        String[] segments = path.substring(1).split("/");
        if (!path.equals("/")) {
            for (String segment : segments) {
                if ("".equals(segment)) {
                    throw new IllegalArgumentException("Path must not contain // : " + path);
                }
                Set<String> children = this.repository.children.get(id);
                if (children == null) {
                    return null;
                }
                String foundId = null;
                for (String childId : children) {
                    SimpleData data = this.repository.datas.get(childId);
                    String name = (String)data.get("cmis:name");
                    if (!segment.equals(name)) continue;
                    foundId = childId;
                    break;
                }
                if (foundId == null) {
                    return null;
                }
                id = foundId;
            }
        }
        return new SimpleObjectEntry(this.repository.datas.get(id), this);
    }

    public Folder getFolder(String path) {
        SimpleObjectEntry entry = (SimpleObjectEntry)this.getObjectByPath(path, null);
        if (entry == null) {
            return null;
        }
        if (entry.getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException("Not a folder: " + path);
        }
        return new SimpleFolder(entry, this);
    }

    public CMISObject getObject(ObjectId object) {
        SimpleData data = this.repository.datas.get(object.getId());
        if (data == null) {
            return null;
        }
        String typeId = (String)data.get("cmis:objectTypeId");
        switch (this.repository.getType(typeId).getBaseType()) {
            case DOCUMENT: {
                return new SimpleDocument(new SimpleObjectEntry(data, this), this);
            }
            case FOLDER: {
                return new SimpleFolder(new SimpleObjectEntry(data, this), this);
            }
            case RELATIONSHIP: {
                return new SimpleRelationship(new SimpleObjectEntry(data, this), this);
            }
            case POLICY: {
                return new SimplePolicy(new SimpleObjectEntry(data, this), this);
            }
        }
        throw new AssertionError((Object)typeId);
    }

    public ListPage<Rendition> getRenditions(ObjectId object, Inclusion inclusion, Paging paging) {
        return SimpleListPage.emptyList();
    }

    public boolean hasContentStream(ObjectId document) {
        SimpleData data = this.repository.datas.get(document.getId());
        byte[] bytes = (byte[])data.get("__content__");
        return bytes != null;
    }

    public ContentStream getContentStream(ObjectId object, String contentStreamId) {
        SimpleData data = this.repository.datas.get(object.getId());
        byte[] bytes = (byte[])data.get("__content__");
        if (bytes == null) {
            return null;
        }
        String mimeType = (String)data.get("cmis:contentStreamMimeType");
        String filename = (String)data.get("cmis:contentStreamFileName");
        return new SimpleContentStream(bytes, mimeType, filename);
    }

    public ObjectId setContentStream(ObjectId document, ContentStream contentStream, boolean overwrite) {
        SimpleData data = this.repository.datas.get(document.getId());
        if (contentStream == null) {
            data.remove("__content__");
            data.remove("cmis:contentStreamMimeType");
            data.remove("cmis:contentStreamFileName");
            data.remove("cmis:contentStreamLength");
        } else {
            byte[] bytes;
            try {
                bytes = SimpleContentStream.getBytes(contentStream.getStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            data.put("__content__", bytes);
            data.put("cmis:contentStreamLength", bytes.length);
            String mt = contentStream.getMimeType();
            if (mt == null) {
                data.remove("cmis:contentStreamMimeType");
            } else {
                data.put("cmis:contentStreamMimeType", mt);
            }
            String fn = contentStream.getFileName();
            if (fn == null) {
                data.remove("cmis:contentStreamFileName");
            } else {
                data.put("cmis:contentStreamFileName", fn);
            }
        }
        return document;
    }

    public ObjectId deleteContentStream(ObjectId document) {
        return this.setContentStream(document, null, true);
    }

    public ObjectId updateProperties(ObjectId object, String changeToken, Map<String, Serializable> properties) {
        SimpleData data = this.repository.datas.get(object.getId());
        String typeId = (String)data.get("cmis:objectTypeId");
        Type type = this.repository.getType(typeId);
        for (String key : properties.keySet()) {
            PropertyDefinition pd;
            Updatability updatability;
            if (key.equals("cmis:objectId") || key.equals("cmis:objectTypeId") || (updatability = (pd = type.getPropertyDefinition(key)).getUpdatability()) == Updatability.ON_CREATE || updatability == Updatability.READ_ONLY) continue;
            Serializable value = properties.get(key);
            if (value == null) {
                if (pd.isRequired()) {
                    throw new RuntimeException("Required property: " + key);
                }
                data.remove(key);
                continue;
            }
            data.put(key, value);
        }
        return object;
    }

    public ObjectId moveObject(ObjectId object, ObjectId targetFolder, ObjectId sourceFolder) {
        String sourceFolderId;
        String id = object.getId();
        if (this.repository.rootId.equals(id)) {
            throw new IllegalArgumentException("Cannot move root");
        }
        SimpleData data = this.repository.datas.get(id);
        if (data == null) {
            throw new ObjectNotFoundException(object.getId());
        }
        this.checkFolder(targetFolder);
        Set<String> parents = this.repository.parents.get(id);
        if (sourceFolder == null) {
            if (parents.size() > 1) {
                throw new ConstraintViolationException("Object " + object.getId() + " has " + parents.size() + " parents");
            }
            sourceFolderId = !parents.isEmpty() ? parents.iterator().next() : null;
        } else {
            sourceFolderId = sourceFolder.getId();
            if (!parents.contains(sourceFolderId)) {
                throw new ConstraintViolationException("Object " + id + " is not filed in " + sourceFolderId);
            }
        }
        if (sourceFolderId != null) {
            parents.remove(sourceFolderId);
            this.repository.children.get(sourceFolderId).remove(id);
        }
        String targetFolderId = targetFolder.getId();
        parents.add(targetFolderId);
        this.repository.children.get(targetFolderId).add(id);
        return object;
    }

    public void deleteObject(ObjectId object, boolean allVersions) {
        Set<String> parents;
        String id = object.getId();
        if (this.repository.rootId.equals(id)) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        SimpleData data = this.repository.datas.get(id);
        if (data == null) {
            throw new ObjectNotFoundException(object.getId());
        }
        Set<String> children = this.repository.children.get(id);
        if (children != null) {
            if (children.size() > 0) {
                throw new ConstraintViolationException("Cannot delete, folder has children: " + object);
            }
            this.repository.children.remove(id);
        }
        if ((parents = this.repository.parents.remove(id)) != null) {
            for (String pid : parents) {
                this.repository.children.get(pid).remove(id);
            }
        }
        this.repository.datas.remove(id);
    }

    public Collection<ObjectId> deleteTree(ObjectId folder, Unfiling unfiling, boolean continueOnFailure) {
        boolean allVersions = false;
        String id = folder.getId();
        if (this.repository.rootId.equals(id)) {
            throw new IllegalArgumentException("Cannot delete root");
        }
        SimpleData data = this.repository.datas.get(id);
        if (data == null) {
            throw new ObjectNotFoundException("No such folder: " + folder.getId());
        }
        String typeId = (String)data.get("cmis:objectTypeId");
        if (this.repository.getType(typeId).getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException("Not a folder: " + folder.getId());
        }
        for (String childId : new ArrayList(this.repository.children.get(id))) {
            SimpleData childData = this.repository.datas.get(childId);
            String childTypeId = (String)childData.get("cmis:objectTypeId");
            SimpleObjectId objectId = new SimpleObjectId(childId);
            if (this.repository.getType(childTypeId).getBaseType() == BaseType.FOLDER) {
                this.deleteTree(objectId, unfiling, continueOnFailure);
                continue;
            }
            this.deleteObject(objectId, allVersions);
        }
        this.deleteObject(folder, false);
        return Collections.emptyList();
    }

    public void addObjectToFolder(ObjectId object, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    public void removeObjectFromFolder(ObjectId object, ObjectId folder) {
        throw new UnsupportedOperationException();
    }

    public ListPage<ObjectEntry> query(String statement, boolean searchAllVersions, Inclusion inclusion, Paging paging) {
        ArrayList<ObjectEntry> all = new ArrayList<ObjectEntry>();
        String tableName = null;
        for (SimpleData data : this.repository.datas.values()) {
            if (tableName != null && !this.typeMatches(tableName, (String)data.get("cmis:objectTypeId"))) continue;
            CmisSqlSimpleWalker.query_return ret = this.queryData(statement, data);
            if (tableName == null && !this.typeMatches(tableName = ret.tableName.toLowerCase(), (String)data.get("cmis:objectTypeId")) || !ret.matches) continue;
            all.add(new SimpleObjectEntry(data, this));
        }
        return SimpleListPage.fromPaging(all, paging);
    }

    protected boolean typeMatches(String tableName, String typeId) {
        Type type;
        do {
            if (!tableName.equals((type = this.repository.getType(typeId)).getQueryName().toLowerCase())) continue;
            return true;
        } while ((typeId = type.getParentId()) != null);
        return false;
    }

    protected CmisSqlSimpleWalker.query_return queryData(String statement, SimpleData data) {
        try {
            ANTLRInputStream input = new ANTLRInputStream((InputStream)new ByteArrayInputStream(statement.getBytes("UTF-8")));
            CmisSqlLexer lexer = new CmisSqlLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            CmisSqlParser parser = new CmisSqlParser((TokenStream)tokens);
            CmisSqlParser.query_return query = parser.query();
            if (parser.errorMessage != null) {
                throw new CMISRuntimeException("Cannot parse query: " + statement + " (" + parser.errorMessage + ")");
            }
            CommonTree tree = (CommonTree)query.getTree();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)tokens);
            CmisSqlSimpleWalker walker = new CmisSqlSimpleWalker((TreeNodeStream)nodes);
            CmisSqlSimpleWalker.query_return res = walker.query(data, this);
            if (walker.errorMessage != null) {
                throw new CMISRuntimeException("Cannot parse query: " + statement + " (" + walker.errorMessage + ")");
            }
            return res;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (RecognitionException e) {
            throw new CMISRuntimeException("Cannot parse query: " + statement, (Throwable)e);
        }
    }

    protected boolean isInFolder(SimpleData data, Object folderId) {
        if (!(folderId instanceof String)) {
            throw new IllegalArgumentException(folderId.toString());
        }
        Set<String> children = this.repository.children.get(folderId);
        if (children == null) {
            return false;
        }
        return children.contains(data.get("cmis:objectId"));
    }

    protected boolean isInTree(SimpleData data, Object folderId) {
        if (!(folderId instanceof String)) {
            throw new IllegalArgumentException(folderId.toString());
        }
        String id = (String)data.get("cmis:objectId");
        if (id == null) {
            return false;
        }
        LinkedList<String> todo = new LinkedList<String>(Collections.singleton(id));
        while (!todo.isEmpty()) {
            String cur = (String)todo.remove();
            Set<String> parents = this.repository.parents.get(cur);
            for (String pid : parents) {
                if (!pid.equals(folderId)) continue;
                return true;
            }
            todo.addAll(parents);
        }
        return false;
    }

    protected boolean fulltextContains(SimpleData data, List<Object> args) {
        String query = args.size() == 2 ? (String)args.get(1) : (String)args.get(0);
        Set<String> words = SimpleFulltext.parseFulltext(data);
        return SimpleFulltext.matchesFullText(words, query);
    }

    public Collection<CMISObject> query(String statement, boolean searchAllVersions) {
        ListPage<ObjectEntry> res = this.query(statement, searchAllVersions, null, null);
        ArrayList<CMISObject> objects = new ArrayList<CMISObject>(res.size());
        for (ObjectEntry e : res) {
            objects.add(SimpleObject.construct((SimpleObjectEntry)e, this));
        }
        return objects;
    }

    public ListPage<ObjectEntry> getChangeLog(String changeLogToken, boolean includeProperties, Paging paging, String[] latestChangeLogToken) {
        latestChangeLogToken[0] = null;
        return SimpleListPage.emptyList();
    }

    public ObjectId checkOut(ObjectId document, boolean[] contentCopied) {
        throw new UnsupportedOperationException();
    }

    public void cancelCheckOut(ObjectId document) {
        throw new UnsupportedOperationException();
    }

    public ObjectId checkIn(ObjectId document, Map<String, Serializable> properties, ContentStream contentStream, boolean major, String comment) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Serializable> getPropertiesOfLatestVersion(String versionSeriesId, boolean major, String filter) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAllVersions(String versionSeriesId, String filter) {
        throw new UnsupportedOperationException();
    }

    public ListPage<ObjectEntry> getRelationships(ObjectId object, String typeId, boolean includeSubRelationshipTypes, Inclusion inclusion, Paging paging) {
        return SimpleListPage.emptyList();
    }

    public void applyPolicy(ObjectId object, ObjectId policy) {
        throw new UnsupportedOperationException();
    }

    public void removePolicy(ObjectId object, ObjectId policy) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAppliedPolicies(ObjectId policy, String filter) {
        return Collections.emptyList();
    }

    public List<ACE> getACL(ObjectId object, boolean onlyBasicPermissions, boolean[] exact) {
        return Collections.emptyList();
    }

    public List<ACE> applyACL(ObjectId object, List<ACE> addACEs, List<ACE> removeACEs, ACLPropagation propagation, boolean[] exact, String[] changeToken) {
        throw new UnsupportedOperationException();
    }
}

