/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleObject;
import org.apache.chemistry.impl.simple.SimpleObjectEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDocument
extends SimpleObject
implements Document {
    public SimpleDocument(SimpleObjectEntry entry, Connection connection) {
        super(entry, connection);
    }

    protected byte[] getContentBytes() {
        return (byte[])this.entry.data.get("__content__");
    }

    public Document checkOut() {
        throw new UnsupportedOperationException();
    }

    public void cancelCheckOut() {
        throw new UnsupportedOperationException();
    }

    public Document checkIn(boolean major, String comment) {
        throw new UnsupportedOperationException();
    }

    public Document getLatestVersion(boolean major) {
        throw new UnsupportedOperationException();
    }

    public Collection<Document> getAllVersions() {
        throw new UnsupportedOperationException();
    }

    public void deleteAllVersions() {
        throw new UnsupportedOperationException();
    }

    public ContentStream getContentStream() {
        byte[] contentBytes = this.getContentBytes();
        if (contentBytes == null) {
            return null;
        }
        String mimeType = this.getString("cmis:contentStreamMimeType");
        String filename = this.getString("cmis:contentStreamFileName");
        return new SimpleContentStream(contentBytes, mimeType, filename);
    }

    public void setContentStream(ContentStream contentStream) throws IOException {
        ContentStreamPresence csa = this.getType().getContentStreamAllowed();
        if (csa == ContentStreamPresence.NOT_ALLOWED && contentStream != null) {
            throw new IllegalStateException("Content stream not allowed");
        }
        if (csa == ContentStreamPresence.REQUIRED && contentStream == null) {
            throw new IllegalStateException("Content stream required");
        }
        if (contentStream == null) {
            this.entry.setValue("cmis:contentStreamLength", null);
            this.entry.setValue("cmis:contentStreamMimeType", null);
            this.entry.setValue("cmis:contentStreamFileName", null);
            this.entry.setValue("__content__", null);
        } else {
            this.entry.setValue("cmis:contentStreamLength", Integer.valueOf((int)contentStream.getLength()));
            this.entry.setValue("cmis:contentStreamMimeType", (Serializable)((Object)contentStream.getMimeType()));
            this.entry.setValue("cmis:contentStreamFileName", (Serializable)((Object)contentStream.getFileName()));
            this.entry.setValue("__content__", (Serializable)SimpleContentStream.getBytes(contentStream.getStream()));
        }
    }

    public Document copy(Folder folder) throws NameConstraintViolationException {
        ObjectId id = this.connection.getSPI().createDocumentFromSource((ObjectId)this, (ObjectId)folder, null, null);
        return new SimpleDocument((SimpleObjectEntry)id, this.connection);
    }
}

