/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Paging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleListPage<T>
extends ArrayList<T>
implements ListPage<T> {
    private static final long serialVersionUID = 1L;
    private static final ListPage EMPTY_LIST = new EmptyPagedList();
    protected boolean hasMoreItems;
    protected int numItems = -1;

    public static final <T> ListPage<T> emptyList() {
        return EMPTY_LIST;
    }

    public SimpleListPage() {
    }

    public SimpleListPage(int initialCapacity) {
        super(initialCapacity);
    }

    public SimpleListPage(Collection<? extends T> collection) {
        super(collection);
    }

    public static ListPage<ObjectEntry> fromPaging(List<ObjectEntry> all, Paging paging) {
        int toIndex;
        int maxItems;
        int fromIndex;
        int total = all.size();
        int n = fromIndex = paging == null ? 0 : paging.skipCount;
        if (fromIndex < 0 || fromIndex > total) {
            return SimpleListPage.emptyList();
        }
        int n2 = maxItems = paging == null ? -1 : paging.maxItems;
        if (maxItems <= 0) {
            maxItems = total;
        }
        if ((toIndex = fromIndex + maxItems) > total) {
            toIndex = total;
        }
        List<ObjectEntry> slice = fromIndex == 0 && toIndex == total ? all : all.subList(fromIndex, toIndex);
        SimpleListPage<ObjectEntry> page = new SimpleListPage<ObjectEntry>((Collection<ObjectEntry>)slice);
        page.setHasMoreItems(toIndex < total);
        page.setNumItems(total);
        return page;
    }

    public boolean getHasMoreItems() {
        return this.hasMoreItems;
    }

    public int getNumItems() {
        return this.numItems;
    }

    public void setHasMoreItems(boolean hasMoreItems) {
        this.hasMoreItems = hasMoreItems;
    }

    public void setNumItems(int numItems) {
        this.numItems = numItems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyPagedList<T>
    extends AbstractList<T>
    implements ListPage<T>,
    RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptyPagedList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }

        public boolean getHasMoreItems() {
            return false;
        }

        public int getNumItems() {
            return 0;
        }
    }
}

