/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.chemistry.AllowableAction;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ChangeInfo;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.impl.simple.SimpleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectEntry
implements ObjectEntry {
    protected final SimpleData data;
    protected ChangeInfo changeInfo;
    protected String path;
    protected String pathSegment;

    public SimpleObjectEntry(SimpleData data, Connection connection) {
        this.data = data;
        this.path = this.getPath(connection);
    }

    public String getId() {
        return (String)this.data.get("cmis:objectId");
    }

    public String getTypeId() {
        return (String)this.data.get("cmis:objectTypeId");
    }

    public BaseType getBaseType() {
        String baseTypeId = (String)this.data.get("cmis:baseTypeId");
        return baseTypeId == null ? null : BaseType.get((String)baseTypeId);
    }

    public ChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public void setChangeInfo(ChangeInfo changeInfo) {
        this.changeInfo = changeInfo;
    }

    public String getPathSegment() {
        return this.pathSegment;
    }

    public void setPathSegment(String pathSegment) {
        this.pathSegment = pathSegment;
    }

    public Map<String, Serializable> getValues() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(this.data);
        if (map.containsKey("cmis:path")) {
            map.put("cmis:path", this.getValue("cmis:path"));
        }
        return map;
    }

    public Serializable getValue(String id) {
        if (id.equals("cmis:path")) {
            return this.path;
        }
        return (Serializable)this.data.get(id);
    }

    protected String getPath(Connection connection) {
        String parentPath;
        ObjectEntry parent;
        if (this.getId() == null) {
            return null;
        }
        if (this.getBaseType() == BaseType.FOLDER) {
            parent = connection.getSPI().getFolderParent((ObjectId)this, null);
        } else {
            Collection parents = connection.getSPI().getObjectParents((ObjectId)this, null);
            if (parents.size() == 0) {
                parent = null;
            } else {
                if (parents.size() > 1) {
                    return null;
                }
                parent = (ObjectEntry)parents.iterator().next();
            }
        }
        if (parent == null) {
            parentPath = "";
        } else {
            parentPath = (String)((Object)parent.getValue("cmis:path"));
            if (parentPath == null) {
                return null;
            }
            if (parentPath.equals("/")) {
                parentPath = "";
            }
        }
        String name = (String)((Object)this.getValue("cmis:name"));
        return parentPath + "/" + name;
    }

    public void setValue(String id, Serializable value) {
        if (value == null) {
            this.data.remove(id);
        } else {
            this.data.put(id, value);
        }
    }

    public void setValues(Map<String, Serializable> values) {
        for (String id : values.keySet()) {
            this.setValue(id, values.get(id));
        }
    }

    public Set<QName> getAllowableActions() {
        boolean canWrite = true;
        boolean isFolder = this.getBaseType() == BaseType.FOLDER;
        HashSet<QName> set = new HashSet<QName>();
        set.add(AllowableAction.CAN_GET_OBJECT_PARENTS);
        set.add(AllowableAction.CAN_GET_PROPERTIES);
        if (isFolder) {
            set.add(AllowableAction.CAN_GET_DESCENDANTS);
            set.add(AllowableAction.CAN_GET_FOLDER_PARENT);
            set.add(AllowableAction.CAN_GET_FOLDER_TREE);
            set.add(AllowableAction.CAN_GET_CHILDREN);
        } else {
            set.add(AllowableAction.CAN_GET_CONTENT_STREAM);
        }
        if (canWrite) {
            if (isFolder) {
                set.add(AllowableAction.CAN_CREATE_DOCUMENT);
                set.add(AllowableAction.CAN_CREATE_FOLDER);
                set.add(AllowableAction.CAN_CREATE_RELATIONSHIP);
                set.add(AllowableAction.CAN_DELETE_TREE);
                set.add(AllowableAction.CAN_ADD_OBJECT_TO_FOLDER);
                set.add(AllowableAction.CAN_REMOVE_OBJECT_FROM_FOLDER);
            } else {
                set.add(AllowableAction.CAN_SET_CONTENT_STREAM);
                set.add(AllowableAction.CAN_DELETE_CONTENT_STREAM);
            }
            set.add(AllowableAction.CAN_UPDATE_PROPERTIES);
            set.add(AllowableAction.CAN_MOVE_OBJECT);
            set.add(AllowableAction.CAN_DELETE_OBJECT);
        }
        if (Boolean.FALSE.booleanValue()) {
            set.add(AllowableAction.CAN_GET_RENDITIONS);
            set.add(AllowableAction.CAN_CHECK_OUT);
            set.add(AllowableAction.CAN_CANCEL_CHECK_OUT);
            set.add(AllowableAction.CAN_CHECK_IN);
            set.add(AllowableAction.CAN_GET_ALL_VERSIONS);
            set.add(AllowableAction.CAN_GET_OBJECT_RELATIONSHIPS);
            set.add(AllowableAction.CAN_APPLY_POLICY);
            set.add(AllowableAction.CAN_REMOVE_POLICY);
            set.add(AllowableAction.CAN_GET_APPLIED_POLICIES);
            set.add(AllowableAction.CAN_GET_ACL);
            set.add(AllowableAction.CAN_APPLY_ACL);
        }
        return set;
    }

    public Collection<ObjectEntry> getRelationships() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getTypeId() + ',' + this.getId() + ')';
    }
}

