/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.Choice;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyDefinition
implements PropertyDefinition {
    protected final String id;
    protected final String localName;
    protected final URI localNamespace;
    protected final String queryName;
    protected final String displayName;
    protected final String description;
    protected final boolean inherited;
    protected final PropertyType type;
    protected final boolean multiValued;
    protected final List<Choice> choices;
    protected final boolean openChoice;
    protected final boolean required;
    protected final Serializable defaultValue;
    protected final Updatability updatability;
    protected final boolean queryable;
    protected final boolean orderable;
    protected final int precision;
    protected final Number minValue;
    protected final Number maxValue;
    protected final int maxLength;
    protected final URI schemaURI;

    public SimplePropertyDefinition(String id, String localName, URI localNamespace, String queryName, String displayName, String description, boolean inherited, PropertyType type, boolean multiValued, List<Choice> choices, boolean openChoice, boolean required, Serializable defaultValue, Updatability updatability, boolean queryable, boolean orderable, int precision, Integer minValue, Integer maxValue, int maxLength, URI schemaURI) {
        if (id.equals("__content__")) {
            throw new IllegalArgumentException("__content__ is a reserved name");
        }
        this.id = id;
        this.localName = localName;
        this.localNamespace = localNamespace;
        this.queryName = queryName;
        this.displayName = displayName;
        this.description = description;
        this.inherited = inherited;
        this.type = type;
        this.multiValued = multiValued;
        this.choices = choices == null ? null : Collections.unmodifiableList(choices);
        this.openChoice = openChoice;
        this.required = required;
        this.defaultValue = defaultValue;
        this.updatability = updatability;
        this.queryable = queryable;
        this.orderable = orderable;
        this.precision = precision;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.maxLength = maxLength;
        this.schemaURI = schemaURI;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalName() {
        return this.localName;
    }

    public URI getLocalNamespace() {
        return this.localNamespace;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public PropertyType getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public boolean isOpenChoice() {
        return this.openChoice;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    public Updatability getUpdatability() {
        return this.updatability;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public int getPrecision() {
        return this.precision;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public URI getSchemaURI() {
        return this.schemaURI;
    }

    public boolean validates(Serializable value) {
        return this.validationError(value) == null;
    }

    public String validationError(Serializable value) {
        if (this.getUpdatability() == Updatability.READ_ONLY) {
            return "Property is read-only";
        }
        if (value == null) {
            if (this.isRequired()) {
                return "Property is required";
            }
            return null;
        }
        boolean multi = this.isMultiValued();
        if (multi != value.getClass().isArray()) {
            return multi ? "Property is multi-valued" : "Property is single-valued";
        }
        Class klass = this.type.klass();
        if (klass == null) {
            throw new UnsupportedOperationException(this.type.toString());
        }
        if (multi) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object v = Array.get(value, i);
                if (v == null) {
                    return "Array value cannot contain null elements";
                }
                if (klass.isInstance(v)) continue;
                return "Array value has type " + v.getClass() + " instead of " + klass.getName();
            }
        } else if (!klass.isInstance(value)) {
            return "Value has type " + value.getClass() + " instead of " + klass.getName();
        }
        return null;
    }
}

