/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.chemistry.ACLCapabilityType;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CapabilityACL;
import org.apache.chemistry.CapabilityChange;
import org.apache.chemistry.CapabilityJoin;
import org.apache.chemistry.CapabilityQuery;
import org.apache.chemistry.CapabilityRendition;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.SPI;
import org.apache.chemistry.impl.base.BaseRepository;
import org.apache.chemistry.impl.simple.SimpleConnection;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.chemistry.impl.simple.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRepository
extends BaseRepository {
    protected static final Set<String> NO_PARENT = Collections.unmodifiableSet(new HashSet());
    protected final String rootId;
    private final ObjectId rootFolderId;
    protected final Map<String, SimpleData> datas = new ConcurrentHashMap<String, SimpleData>();
    protected final Map<String, Set<String>> children = new ConcurrentHashMap<String, Set<String>>();
    protected final Map<String, Set<String>> parents = new ConcurrentHashMap<String, Set<String>>();

    public SimpleRepository(String name, Collection<SimpleType> types, String rootId) {
        this(name, rootId);
        this.addTypes(SimpleRepository.getDefaultTypes());
        this.addTypes(types);
    }

    public SimpleRepository(String name, String rootId) {
        super(name);
        SimpleData rootData = new SimpleData("chemistry:root", BaseType.FOLDER);
        if (rootId == null) {
            rootId = this.generateId();
        }
        this.rootId = rootId;
        rootData.put("cmis:objectId", rootId);
        rootData.put("cmis:name", "");
        this.datas.put(rootId, rootData);
        this.children.put(rootId, this.newSet());
        this.parents.put(rootId, NO_PARENT);
        this.rootFolderId = new SimpleObjectId(rootId);
    }

    protected String generateId() {
        return UUID.randomUUID().toString();
    }

    protected Set<String> newSet() {
        return Collections.synchronizedSet(new HashSet());
    }

    public URI getThinClientURI() {
        return null;
    }

    public Connection getConnection(Map<String, Serializable> params) {
        return new SimpleConnection(this);
    }

    public SPI getSPI(Map<String, Serializable> params) {
        return new SimpleConnection(this);
    }

    public <T> T getExtension(Class<T> klass) {
        return null;
    }

    public String getDescription() {
        return "Repository " + this.name;
    }

    public ObjectId getRootFolderId() {
        return this.rootFolderId;
    }

    public String getProductName() {
        return "Chemistry Simple Repository";
    }

    public Set<BaseType> getChangeLogBaseTypes() {
        HashSet<BaseType> changeLogBaseTypes = new HashSet<BaseType>();
        changeLogBaseTypes.add(BaseType.DOCUMENT);
        changeLogBaseTypes.add(BaseType.FOLDER);
        changeLogBaseTypes.add(BaseType.RELATIONSHIP);
        changeLogBaseTypes.add(BaseType.POLICY);
        return changeLogBaseTypes;
    }

    public boolean isChangeLogIncomplete() {
        return false;
    }

    public String getLatestChangeLogToken() {
        return "";
    }

    public ACLCapabilityType getACLCapabilityType() {
        return null;
    }

    public boolean hasMultifiling() {
        return false;
    }

    public boolean hasUnfiling() {
        return false;
    }

    public boolean hasVersionSpecificFiling() {
        return false;
    }

    public boolean isPWCUpdatable() {
        return false;
    }

    public boolean isPWCSearchable() {
        return false;
    }

    public boolean isAllVersionsSearchable() {
        return false;
    }

    public boolean hasGetDescendants() {
        return true;
    }

    public boolean hasGetFolderTree() {
        return true;
    }

    public boolean isContentStreamUpdatableAnytime() {
        return true;
    }

    public CapabilityJoin getJoinCapability() {
        return CapabilityJoin.NONE;
    }

    public CapabilityQuery getQueryCapability() {
        return CapabilityQuery.BOTH_COMBINED;
    }

    public CapabilityRendition getRenditionCapability() {
        return CapabilityRendition.NONE;
    }

    public CapabilityChange getChangeCapability() {
        return CapabilityChange.NONE;
    }

    public CapabilityACL getACLCapability() {
        return CapabilityACL.NONE;
    }
}

