/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ContentStreamPresence;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.Type;
import org.apache.chemistry.Updatability;
import org.apache.chemistry.impl.simple.SimplePropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleType
implements Type {
    public static final SimplePropertyDefinition PROP_ID = new SimplePropertyDefinition("cmis:objectId", "def:id", null, "cmis:objectId", "Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_TYPE_ID = new SimplePropertyDefinition("cmis:objectTypeId", "def:typeid", null, "cmis:objectTypeId", "Type ID", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_BASE_TYPE_ID = new SimplePropertyDefinition("cmis:baseTypeId", "def:basetypeid", null, "cmis:baseTypeId", "Base Type ID", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_NAME = new SimplePropertyDefinition("cmis:name", "def:name", null, "cmis:name", "Name", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CREATED_BY = new SimplePropertyDefinition("cmis:createdBy", "def:createdby", null, "cmis:createdBy", "Created By", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CREATION_DATE = new SimplePropertyDefinition("cmis:creationDate", "def:creationdate", null, "cmis:creationDate", "Creation Date", "", false, PropertyType.DATETIME, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_LAST_MODIFIED_BY = new SimplePropertyDefinition("cmis:lastModifiedBy", "def:lastmodifiedby", null, "cmis:lastModifiedBy", "Last Modified By", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_LAST_MODIFICATION_DATE = new SimplePropertyDefinition("cmis:lastModificationDate", "def:lastmodificationdate", null, "cmis:lastModificationDate", "Last Modification Date", "", false, PropertyType.DATETIME, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CHANGE_TOKEN = new SimplePropertyDefinition("cmis:changeToken", "def:changetoken", null, "cmis:changeToken", "Change Token", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_IS_LATEST_VERSION = new SimplePropertyDefinition("cmis:isLatestVersion", "def:islatestversion", null, "cmis:isLatestVersion", "Is Latest Version", "", false, PropertyType.BOOLEAN, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_IS_MAJOR_VERSION = new SimplePropertyDefinition("cmis:isMajorVersion", "def:ismajorversion", null, "cmis:isMajorVersion", "Is Major Version", "", false, PropertyType.BOOLEAN, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_IS_LATEST_MAJOR_VERSION = new SimplePropertyDefinition("cmis:isLatestMajorVersion", "def:islatestmajorversion", null, "cmis:isLatestMajorVersion", "Is Latest Major Version", "", false, PropertyType.BOOLEAN, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_VERSION_LABEL = new SimplePropertyDefinition("cmis:versionLabel", "def:versionlabel", null, "cmis:versionLabel", "Version Label", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_VERSION_SERIES_ID = new SimplePropertyDefinition("cmis:versionSeriesId", "def:versionseriesid", null, "cmis:versionSeriesId", "Version Series ID", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_IS_VERSION_SERIES_CHECKED_OUT = new SimplePropertyDefinition("cmis:isVersionSeriesCheckedOut", "def:isversionseriescheckedout", null, "cmis:isVersionSeriesCheckedOut", "Is Version Series Checked Out", "", false, PropertyType.BOOLEAN, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_VERSION_SERIES_CHECKED_OUT_BY = new SimplePropertyDefinition("cmis:versionSeriesCheckedOutBy", "def:versionseriescheckedoutby", null, "cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_VERSION_SERIES_CHECKED_OUT_ID = new SimplePropertyDefinition("cmis:versionSeriesCheckedOutId", "def:versionseriescheckedoutid", null, "cmis:versionSeriesCheckedOutId", "Version Series Checked Out Id", "", false, PropertyType.ID, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CHECK_IN_COMMENT = new SimplePropertyDefinition("cmis:checkinComment", "def:checkincomment", null, "cmis:checkinComment", "Check In Comment", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CONTENT_STREAM_LENGTH = new SimplePropertyDefinition("cmis:contentStreamLength", "def:contentstreamlength", null, "cmis:contentStreamLength", "Content Stream Length", "", false, PropertyType.INTEGER, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CONTENT_STREAM_MIME_TYPE = new SimplePropertyDefinition("cmis:contentStreamMimeType", "def:contentstreammimetype", null, "cmis:contentStreamMimeType", "Content Stream MIME Type", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CONTENT_STREAM_FILE_NAME = new SimplePropertyDefinition("cmis:contentStreamFileName", "def:contentstreamfilename", null, "cmis:contentStreamFileName", "Content Stream File Name", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_CONTENT_STREAM_ID = new SimplePropertyDefinition("cmis:contentStreamId", "def:contentstreamid", null, "cmis:contentStreamId", "Content Stream ID", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_PARENT_ID = new SimplePropertyDefinition("cmis:parentId", "def:parentid", null, "cmis:parentId", "Parent Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_PATH = new SimplePropertyDefinition("cmis:path", "def:path", null, "cmis:path", "Path", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_ALLOWED_CHILD_OBJECT_TYPE_IDS = new SimplePropertyDefinition("cmis:allowedChildObjectTypeIds", "def:allowedchildobjecttypeids", null, "cmis:allowedChildObjectTypeIds", "Allowed Child Object Type Ids", "", false, PropertyType.ID, true, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_SOURCE_ID = new SimplePropertyDefinition("cmis:sourceId", "def:sourceid", null, "cmis:sourceId", "Source Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_TARGET_ID = new SimplePropertyDefinition("cmis:targetId", "def:targetid", null, "cmis:targetId", "Target Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
    public static final SimplePropertyDefinition PROP_POLICY_TEXT = new SimplePropertyDefinition("cmis:policyText", "def:policytext", null, "cmis:policyText", "Policy Text", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null);
    private static final PropertyDefinition[] PROPS_COMMON = new PropertyDefinition[]{PROP_ID, PROP_TYPE_ID, PROP_BASE_TYPE_ID, PROP_NAME, PROP_CREATED_BY, PROP_CREATION_DATE, PROP_LAST_MODIFIED_BY, PROP_LAST_MODIFICATION_DATE, PROP_CHANGE_TOKEN};
    public static final List<PropertyDefinition> PROPS_DOCUMENT_BASE = SimpleType.commonPlus(PROP_IS_LATEST_VERSION, PROP_IS_MAJOR_VERSION, PROP_IS_LATEST_MAJOR_VERSION, PROP_VERSION_LABEL, PROP_VERSION_SERIES_ID, PROP_IS_VERSION_SERIES_CHECKED_OUT, PROP_VERSION_SERIES_CHECKED_OUT_BY, PROP_VERSION_SERIES_CHECKED_OUT_ID, PROP_CHECK_IN_COMMENT, PROP_CONTENT_STREAM_LENGTH, PROP_CONTENT_STREAM_MIME_TYPE, PROP_CONTENT_STREAM_FILE_NAME, PROP_CONTENT_STREAM_ID);
    public static final List<PropertyDefinition> PROPS_FOLDER_BASE = SimpleType.commonPlus(PROP_PARENT_ID, PROP_PATH, PROP_ALLOWED_CHILD_OBJECT_TYPE_IDS);
    public static final List<PropertyDefinition> PROPS_RELATIONSHIP_BASE = SimpleType.commonPlus(PROP_SOURCE_ID, PROP_TARGET_ID);
    public static final List<PropertyDefinition> PROPS_POLICY_BASE = SimpleType.commonPlus(PROP_POLICY_TEXT);
    public static final Map<String, PropertyDefinition> PROPS_MAP;
    protected final String id;
    protected final String localName;
    protected final URI localNamespace;
    protected final String queryName;
    protected final String displayName;
    protected final String parentId;
    protected final BaseType baseType;
    protected final String description;
    protected final boolean creatable;
    protected final boolean queryable;
    protected final boolean controllablePolicy;
    protected final boolean controllableACL;
    protected final boolean fulltextIndexed;
    protected final boolean includedInSuperTypeQuery;
    protected final boolean fileable;
    protected final boolean versionable;
    protected final ContentStreamPresence contentStreamAllowed;
    protected final String[] allowedSourceTypes;
    protected final String[] allowedTargetTypes;
    protected final Map<String, PropertyDefinition> propertyDefinitions;

    private static List<PropertyDefinition> commonPlus(PropertyDefinition ... array) {
        ArrayList<PropertyDefinition> list = new ArrayList<PropertyDefinition>(PROPS_COMMON.length + array.length);
        list.addAll(Arrays.asList(PROPS_COMMON));
        list.addAll(Arrays.asList(array));
        return Collections.unmodifiableList(list);
    }

    public SimpleType(String id, String parentId, String localName, URI localNamespace, String queryName, String displayName, BaseType baseType, String description, boolean creatable, boolean queryable, boolean controllablePolicy, boolean controllableACL, boolean fulltextIndexed, boolean includedInSuperTypeQuery, boolean fileable, boolean versionable, ContentStreamPresence contentStreamAllowed, String[] allowedSourceTypes, String[] allowedTargetTypes, Collection<PropertyDefinition> propertyDefinitions) {
        this(id, parentId, localName, localNamespace, queryName, displayName, baseType, description, creatable, queryable, controllablePolicy, controllableACL, fulltextIndexed, includedInSuperTypeQuery, fileable, versionable, contentStreamAllowed, allowedSourceTypes, allowedTargetTypes);
        this.addPropertyDefinitions(SimpleType.getBasePropertyDefinitions(baseType));
        this.addPropertyDefinitions(propertyDefinitions);
    }

    public SimpleType(String id, String parentId, String localName, URI localNamespace, String queryName, String displayName, BaseType baseType, String description, boolean creatable, boolean queryable, boolean controllablePolicy, boolean controllableACL, boolean fulltextIndexed, boolean includedInSuperTypeQuery, boolean fileable, boolean versionable, ContentStreamPresence contentStreamAllowed, String[] allowedSourceTypes, String[] allowedTargetTypes) {
        this.id = id;
        this.parentId = parentId;
        this.localName = localName;
        this.localNamespace = localNamespace;
        this.queryName = queryName;
        this.displayName = displayName;
        this.baseType = baseType;
        this.description = description;
        this.creatable = creatable;
        this.queryable = queryable;
        this.controllablePolicy = controllablePolicy;
        this.controllableACL = controllableACL;
        this.fulltextIndexed = fulltextIndexed;
        this.includedInSuperTypeQuery = includedInSuperTypeQuery;
        this.fileable = fileable;
        this.versionable = versionable;
        this.contentStreamAllowed = contentStreamAllowed;
        this.allowedSourceTypes = allowedSourceTypes;
        this.allowedTargetTypes = allowedTargetTypes;
        this.propertyDefinitions = new LinkedHashMap<String, PropertyDefinition>();
    }

    protected void addPropertyDefinitions(Collection<PropertyDefinition> defs) {
        for (PropertyDefinition def : defs) {
            String id = def.getId();
            if (this.propertyDefinitions.containsKey(id)) {
                throw new RuntimeException("Property already defined for name: " + id);
            }
            this.propertyDefinitions.put(id, def);
        }
    }

    public static List<PropertyDefinition> getBasePropertyDefinitions(BaseType baseType) {
        switch (baseType) {
            case DOCUMENT: {
                return PROPS_DOCUMENT_BASE;
            }
            case FOLDER: {
                return PROPS_FOLDER_BASE;
            }
            case RELATIONSHIP: {
                return PROPS_RELATIONSHIP_BASE;
            }
            case POLICY: {
                return PROPS_POLICY_BASE;
            }
        }
        throw new AssertionError();
    }

    public String getId() {
        return this.id;
    }

    public String getLocalName() {
        return this.localName;
    }

    public URI getLocalNamespace() {
        return this.localNamespace;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public boolean isControllablePolicy() {
        return this.controllablePolicy;
    }

    public boolean isControllableACL() {
        return this.controllableACL;
    }

    public boolean isFulltextIndexed() {
        return this.fulltextIndexed;
    }

    public boolean isIncludedInSuperTypeQuery() {
        return this.includedInSuperTypeQuery;
    }

    public boolean isFileable() {
        return this.fileable;
    }

    public boolean isVersionable() {
        return this.versionable;
    }

    public ContentStreamPresence getContentStreamAllowed() {
        return this.contentStreamAllowed;
    }

    public String[] getAllowedSourceTypes() {
        return this.allowedSourceTypes;
    }

    public String[] getAllowedTargetTypes() {
        return this.allowedTargetTypes;
    }

    public Collection<PropertyDefinition> getPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.propertyDefinitions.values());
    }

    public PropertyDefinition getPropertyDefinition(String id) {
        return this.propertyDefinitions.get(id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getId() + ')';
    }

    static {
        HashMap<String, PropertyDefinition> map = new HashMap<String, PropertyDefinition>();
        for (List lpd : Arrays.asList(PROPS_DOCUMENT_BASE, PROPS_FOLDER_BASE, PROPS_RELATIONSHIP_BASE, PROPS_POLICY_BASE)) {
            for (PropertyDefinition pd : lpd) {
                map.put(pd.getId(), pd);
            }
        }
        PROPS_MAP = Collections.unmodifiableMap(map);
    }
}

