/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.Paging;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Type;
import org.apache.chemistry.TypeManager;
import org.apache.chemistry.impl.simple.SimpleListPage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeManager
implements TypeManager {
    private static final Log log = LogFactory.getLog(SimpleTypeManager.class);
    protected final Map<String, Type> types = new LinkedHashMap<String, Type>();
    protected final Map<String, PropertyDefinition> propertyDefinitions = new HashMap<String, PropertyDefinition>();
    protected final Map<String, Collection<Type>> typesChildren;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Lock rlock = this.rwlock.readLock();
    private final Lock wlock = this.rwlock.writeLock();

    public SimpleTypeManager() {
        this.typesChildren = new HashMap<String, Collection<Type>>();
        for (String bid : BaseType.ALL_IDS) {
            this.typesChildren.put(bid, new LinkedList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addType(Type type) {
        block9: {
            this.wlock.lock();
            try {
                String typeId = type.getId();
                if (this.types.containsKey(typeId)) {
                    throw new RuntimeException("Type already defined: " + typeId);
                }
                this.types.put(typeId, type);
                for (PropertyDefinition pdef : type.getPropertyDefinitions()) {
                    this.addPropertyDefinition(pdef);
                }
                this.typesChildren.put(typeId, new LinkedList());
                String parentId = type.getParentId();
                if (parentId == null) {
                    try {
                        BaseType.get((String)typeId);
                        break block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Type: " + typeId + " must have a parent type");
                    }
                }
                Collection<Type> siblings = this.typesChildren.get(parentId);
                if (siblings == null) {
                    throw new IllegalArgumentException("Type: " + typeId + " refers to unknown parent: " + parentId);
                }
                siblings.add(type);
            }
            finally {
                this.wlock.unlock();
            }
        }
    }

    protected void addPropertyDefinition(PropertyDefinition pdef) {
        PropertyDefinition old = this.propertyDefinitions.get(pdef.getId());
        if (old != null) {
            if (!(SimpleTypeManager.eq(old.getLocalName(), pdef.getLocalName()) && SimpleTypeManager.eq(old.getDisplayName(), pdef.getDisplayName()) && SimpleTypeManager.eq(old.getQueryName(), pdef.getQueryName()) && old.getType().equals((Object)pdef.getType()))) {
                log.error((Object)("Property definition redefined differently: " + pdef.getId()));
            }
            return;
        }
        this.propertyDefinitions.put(pdef.getId(), pdef);
    }

    protected static boolean eq(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getType(String typeId) {
        this.rlock.lock();
        try {
            Type type = this.types.get(typeId);
            return type;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDefinition getPropertyDefinition(String id) {
        this.rlock.lock();
        try {
            PropertyDefinition propertyDefinition = this.propertyDefinitions.get(id);
            return propertyDefinition;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Type> getTypes() {
        this.rlock.lock();
        try {
            ArrayList<Type> arrayList = new ArrayList<Type>(this.types.values());
            return arrayList;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public Collection<Type> getTypeDescendants(String typeId) {
        Collection<Type> list = this.getTypeDescendants(typeId, -1, true);
        if (typeId != null) {
            Type type = this.getType(typeId);
            ((LinkedList)list).addFirst(type);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListPage<Type> getTypeChildren(String typeId, boolean includePropertyDefinitions, Paging paging) {
        this.rlock.lock();
        try {
            ArrayList<Object> list;
            if (typeId == null) {
                list = new ArrayList(4);
                for (String id : BaseType.ALL_IDS) {
                    Type type = this.types.get(id);
                    if (type == null) continue;
                    list.add(type);
                }
            } else {
                Collection<Type> children = this.typesChildren.get(typeId);
                if (children == null) {
                    throw new IllegalArgumentException("No such type: " + typeId);
                }
                list = new ArrayList<Type>(children);
            }
            SimpleListPage<Type> simpleListPage = new SimpleListPage<Type>((Collection<Type>)list);
            return simpleListPage;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Type> getTypeDescendants(String typeId, int depth, boolean returnPropertyDefinitions) {
        this.rlock.lock();
        try {
            if (depth == 0) {
                throw new IllegalArgumentException("Depth 0 invalid");
            }
            LinkedList<Type> list = new LinkedList<Type>();
            HashSet<String> done = new HashSet<String>();
            if (typeId == null) {
                for (String tid : BaseType.ALL_IDS) {
                    Type type = this.types.get(tid);
                    if (type == null) continue;
                    list.add(type);
                    this.collectSubTypes(tid, -1, returnPropertyDefinitions, list, done);
                }
            } else {
                if (!this.types.containsKey(typeId)) {
                    throw new IllegalArgumentException("No such type: " + typeId);
                }
                this.collectSubTypes(typeId, depth, returnPropertyDefinitions, list, done);
            }
            LinkedList<Type> linkedList = list;
            return linkedList;
        }
        finally {
            this.rlock.unlock();
        }
    }

    protected void collectSubTypes(String typeId, int depth, boolean returnPropertyDefinitions, List<Type> list, Set<String> done) {
        if (depth == 0) {
            return;
        }
        for (Type subType : this.typesChildren.get(typeId)) {
            String subTypeId = subType.getId();
            if (done.contains(subTypeId)) {
                throw new IllegalStateException("Types contain a cycle involving: " + subTypeId);
            }
            done.add(subTypeId);
            list.add(subType);
            this.collectSubTypes(subTypeId, depth - 1, returnPropertyDefinitions, list, done);
        }
    }
}

