/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.xml.stax;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.xml.stax.ParseException;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementIterator<T>
implements Iterator<T> {
    protected final StaxReader reader;
    protected Boolean hasNext;

    public ElementIterator(StaxReader sr) {
        this.reader = sr;
    }

    protected abstract T getValue() throws XMLStreamException;

    protected boolean forward() throws XMLStreamException {
        return this.reader.fwd();
    }

    protected boolean accept() {
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            try {
                while (this.forward()) {
                    if (!this.accept()) continue;
                    this.hasNext = Boolean.TRUE;
                    return true;
                }
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
            this.hasNext = Boolean.FALSE;
            return false;
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in stream");
        }
        this.hasNext = null;
        try {
            return this.getValue();
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

