/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.notification;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.common.utils.i18n.Labeler;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.base.InputController;

@Name(value="groupsSubscriptionsAction")
@Scope(value=ScopeType.PAGE)
public class GroupsSubscriptionsAction
extends InputController
implements Serializable {
    private static final long serialVersionUID = -2440187703248677446L;
    private static final Labeler labeler = new Labeler("label.subscriptions");
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected Principal currentUser;
    @In(required=false)
    @Out(required=false)
    private List<String> selectedNotifications;
    @In(create=true)
    protected transient NotificationManager notificationManager;
    private String selectedGrant;
    private String selectedNotification;
    private SelectItem[] permissionActionItems;
    protected List<String> selectedEntries;

    public List<SelectItem> getNotificationList() throws ClientException {
        String parentType = this.documentManager.getSuperParentType(this.navigationContext.getCurrentDocument());
        List notifs = this.notificationManager.getNotificationsForSubscriptions(parentType);
        ArrayList<SelectItem> notifsResult = new ArrayList<SelectItem>();
        for (Notification notification : notifs) {
            String notifName = notification.getName();
            String notifLabel = notification.getLabel();
            notifsResult.add(new SelectItem((Object)notifName, (String)this.resourcesAccessor.getMessages().get(notifLabel)));
        }
        return notifsResult;
    }

    public void updateSubscriptions() throws ClientException {
        List<String> selectedNotifications = this.getSelectedNotifications();
        List<String> subscriptions = this.getSubscriptionsForCurrentUser();
        List<String> newSubscriptions = GroupsSubscriptionsAction.getDisjunctElements(selectedNotifications, subscriptions);
        List<String> removedSubscriptions = GroupsSubscriptionsAction.getDisjunctElements(subscriptions, selectedNotifications);
        NuxeoPrincipal principal = (NuxeoPrincipal)this.currentUser;
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (!removedSubscriptions.isEmpty()) {
            for (String subscription : removedSubscriptions) {
                this.notificationManager.removeSubscription("user:" + principal.getName(), subscription, currentDoc.getId());
            }
        }
        if (!newSubscriptions.isEmpty()) {
            for (String subscription : newSubscriptions) {
                this.notificationManager.addSubscription("user:" + principal.getName(), subscription, currentDoc, Boolean.valueOf(false), principal, "");
            }
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.notifications.registered"), new Object[0]);
    }

    private static List<String> getDisjunctElements(List<String> array1, List<String> array2) {
        ArrayList<String> result = new ArrayList<String>();
        for (String elem1 : array1) {
            if (array2.contains(elem1)) continue;
            result.add(elem1);
        }
        return result;
    }

    public List<String> getSelectedNotifications() throws ClientException {
        if (this.selectedNotifications == null) {
            this.selectedNotifications = this.getSubscriptionsForCurrentUser();
        }
        return this.selectedNotifications;
    }

    private List<String> getSubscriptionsForCurrentUser() throws ClientException {
        List subscriptions;
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.currentUser;
        try {
            subscriptions = this.notificationManager.getSubscriptionsForUserOnDocument("user:" + principal.getName(), currentDoc.getId());
        }
        catch (ClassNotFoundException e) {
            throw new ClientException((Throwable)e);
        }
        return subscriptions;
    }

    public List<String> getSubscribedUsersForNotification(String notification) throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.notificationManager.getUsersSubscribedToNotificationOnDocument(notification, currentDoc.getId());
    }

    public Map<String, List<String>> getUsersByNotificationsForCurrentDocument() throws ClientException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        String superParentType = this.documentManager.getSuperParentType(this.navigationContext.getCurrentDocument());
        List notifications = this.notificationManager.getNotificationsForSubscriptions(superParentType);
        for (Notification notification : notifications) {
            result.put(notification.getLabel(), this.getSubscribedUsersForNotification(notification.getName()));
        }
        return result;
    }

    public void setSelectedNotifications(List<String> selectedNotifications) {
        this.selectedNotifications = selectedNotifications;
    }

    public SelectItem[] getNotificationActionItems() {
        ArrayList<String> permissionActions = new ArrayList<String>();
        ArrayList<SelectItem> jsfModelList = new ArrayList<SelectItem>();
        permissionActions.add("Subscribe");
        permissionActions.add("Unsubscribe");
        for (String permissionAction : permissionActions) {
            String label = labeler.makeLabel(permissionAction);
            SelectItem it = new SelectItem((Object)permissionAction, (String)this.resourcesAccessor.getMessages().get(label));
            jsfModelList.add(it);
        }
        this.permissionActionItems = jsfModelList.toArray(new SelectItem[0]);
        return this.permissionActionItems;
    }

    public String getSelectedGrant() {
        return this.selectedGrant;
    }

    public void setSelectedGrant(String selectedPermission) {
        this.selectedGrant = selectedPermission;
    }

    public String getSelectedNotification() {
        return this.selectedNotification;
    }

    public void setSelectedNotification(String selectedNotification) {
        this.selectedNotification = selectedNotification;
    }

    public boolean getCanAddSubscriptions() throws ClientException {
        return this.documentManager.hasPermission(this.currentDocument.getRef(), "WriteSecurity");
    }

    public String addSubscriptionsAndUpdate() throws ClientException {
        if (this.selectedEntries == null || this.selectedEntries.isEmpty()) {
            String message = ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)"error.notifManager.noUserSelected");
            FacesMessages.instance().add(message, new Object[0]);
            return null;
        }
        String notificationName = (String)this.resourcesAccessor.getMessages().get(this.notificationManager.getNotificationByName(this.selectedNotification).getLabel());
        boolean subscribe = this.selectedGrant.equals("Subscribe");
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        NuxeoPrincipal currentPrincipal = (NuxeoPrincipal)this.currentUser;
        for (String selectedEntry : this.selectedEntries) {
            if (subscribe) {
                this.notificationManager.addSubscription(selectedEntry, this.selectedNotification, currentDoc, Boolean.valueOf(true), currentPrincipal, notificationName);
                continue;
            }
            this.notificationManager.removeSubscription(selectedEntry, this.selectedNotification, currentDoc.getId());
        }
        this.selectedEntries = null;
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.notifications.registered"), new Object[0]);
        return null;
    }

    public List<String> getSelectedEntries() {
        if (this.selectedEntries == null) {
            this.selectedEntries = new ArrayList<String>();
        }
        return this.selectedEntries;
    }

    public void setSelectedEntries(List<String> selectedEntries) {
        this.selectedEntries = selectedEntries;
    }
}

