/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class ServiceManagement
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.api.ServiceManagement");
    private ServiceManager manager;

    @Override
    public void activate(ComponentContext context) throws Exception {
        this.manager = ServiceManager.getInstance();
    }

    @Override
    public void deactivate(ComponentContext context) throws Exception {
        this.manager = null;
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("servers")) {
            try {
                this.manager.registerServer((ServiceHost)contribution);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (extensionPoint.equals("services")) {
            this.manager.registerService((ServiceDescriptor)contribution);
        }
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("servers")) {
            this.manager.unregisterServer((ServiceHost)contribution);
        } else if (extensionPoint.equals("services")) {
            this.manager.unregisterService((ServiceDescriptor)contribution);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ServiceManager.class.isAssignableFrom(adapter)) {
            return (T)this.manager;
        }
        return null;
    }
}

