/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.ejb.bean;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.PostActivate;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ec.notification.ejb.bean.SerializableNotificationRegistry;
import org.nuxeo.ecm.platform.ec.notification.ejb.facade.NotificationServiceLocal;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationRegistryImpl;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.notification.api.NotificationRegistry;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={NotificationServiceLocal.class})
@Remote(value={NotificationManager.class})
public class NotificationServiceBean
implements NotificationManager {
    private static final Log log = LogFactory.getLog(NotificationServiceBean.class);
    protected NotificationManager service;

    @PostActivate
    @PostConstruct
    public void initialize() {
        try {
            this.service = (NotificationManager)Framework.getLocalService(NotificationManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get relation service", (Throwable)e);
        }
    }

    public void addSubscription(String username, String notification, DocumentModel doc, Boolean sendConfirmationEmail, NuxeoPrincipal principal, String notificationName) throws ClientException {
        this.service.addSubscription(username, notification, doc, sendConfirmationEmail, principal, notificationName);
    }

    public List<String> getSubscribers(String notification, String docId) throws ClientException {
        return this.service.getSubscribers(notification, docId);
    }

    public List<String> getSubscriptionsForUserOnDocument(String username, String docId) throws ClassNotFoundException, ClientException {
        return this.service.getSubscriptionsForUserOnDocument(username, docId);
    }

    public List<String> getUsersSubscribedToNotificationOnDocument(String notification, String docId) throws ClientException {
        return this.service.getUsersSubscribedToNotificationOnDocument(notification, docId);
    }

    public void removeSubscription(String username, String notification, String docId) throws ClientException {
        this.service.removeSubscription(username, notification, docId);
    }

    @Deprecated
    public NotificationRegistry getNotificationRegistry() {
        NotificationRegistryImpl registry = (NotificationRegistryImpl)this.service.getNotificationRegistry();
        return new SerializableNotificationRegistry(registry);
    }

    public Notification getNotificationByName(String selectedNotification) {
        return this.service.getNotificationByName(selectedNotification);
    }

    public List<Notification> getNotificationsForSubscriptions(String parentType) {
        return this.service.getNotificationsForSubscriptions(parentType);
    }

    public void sendDocumentByMail(DocumentModel doc, String freemarkerTemplateName, String subject, String comment, NuxeoPrincipal sender, List<String> sendTo) {
        this.service.sendDocumentByMail(doc, freemarkerTemplateName, subject, comment, sender, sendTo);
    }

    public void sendNotification(String notificationName, Map<String, Object> infoMap, String userPrincipal) throws ClientException {
        this.service.sendNotification(notificationName, infoMap, userPrincipal);
    }

    public List<Notification> getNotificationsForEvents(String eventId) {
        return this.service.getNotificationsForEvents(eventId);
    }
}

