/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.ooomanager;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeConnectionProtocol;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.convert.ooomanager.ConfigBuilderHelper;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerDescriptor;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OOoManagerComponent
extends DefaultComponent
implements OOoManagerService,
FrameworkListener {
    protected static final Log log = LogFactory.getLog(OOoManagerComponent.class);
    private static final String CONNECTION_PROTOCOL_PROPERTY_KEY = "jod.connection.protocol";
    private static final String MAX_TASKS_PER_PROCESS_PROPERTY_KEY = "jod.max.tasks.per.process";
    private static final String OFFICE_HOME_PROPERTY_KEY = "jod.office.home";
    private static final String TASK_EXECUTION_TIMEOUT_PROPERTY_KEY = "jod.task.execution.timeout";
    private static final String TASK_QUEUE_TIMEOUT_PROPERTY_KEY = "jod.task.queue.timeout";
    private static final String TEMPLATE_PROFILE_DIR_PROPERTY_KEY = "jod.template.profile.dir";
    protected static String CONFIG_EP = "oooManagerConfig";
    private static OfficeManager officeManager;
    protected OOoManagerDescriptor descriptor = new OOoManagerDescriptor();
    protected boolean started = false;

    public OOoManagerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIG_EP.equals(extensionPoint)) {
            OOoManagerDescriptor desc;
            this.descriptor = desc = (OOoManagerDescriptor)contribution;
        }
    }

    public void activate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.stopOOoManager();
    }

    @Override
    public OfficeDocumentConverter getDocumentConverter() {
        if (this.isOOoManagerStarted()) {
            return new OfficeDocumentConverter(officeManager);
        }
        log.error((Object)"OfficeManager is not started.");
        return null;
    }

    @Override
    public void stopOOoManager() {
        if (this.started) {
            officeManager.stop();
            log.debug((Object)"Stoping ooo manager.");
        } else {
            log.debug((Object)"OOoManager already stoped..");
        }
    }

    @Override
    public void startOOoManager() throws IOException {
        int[] portNumbers;
        String[] pipeNames;
        String templateProfileDir;
        String taskQueueTimeoutProperty;
        String taskExecutionTimeoutProperty;
        String officeHome;
        String maxTasksPerProcessProperty;
        DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
        String connectionProtocol = Framework.getProperty((String)CONNECTION_PROTOCOL_PROPERTY_KEY);
        if (connectionProtocol != null && !"".equals(connectionProtocol)) {
            if (OfficeConnectionProtocol.PIPE.toString().equals(connectionProtocol)) {
                ConfigBuilderHelper.hackClassLoader();
                configuration.setConnectionProtocol(OfficeConnectionProtocol.PIPE);
            } else if (OfficeConnectionProtocol.SOCKET.toString().equals(connectionProtocol)) {
                configuration.setConnectionProtocol(OfficeConnectionProtocol.SOCKET);
            }
        }
        if ((maxTasksPerProcessProperty = Framework.getProperty((String)MAX_TASKS_PER_PROCESS_PROPERTY_KEY)) != null && !"".equals(maxTasksPerProcessProperty)) {
            Integer maxTasksPerProcess = Integer.valueOf(maxTasksPerProcessProperty);
            configuration.setMaxTasksPerProcess(maxTasksPerProcess.intValue());
        }
        if ((officeHome = Framework.getProperty((String)OFFICE_HOME_PROPERTY_KEY)) != null && !"".equals(officeHome)) {
            configuration.setOfficeHome(officeHome);
        }
        if ((taskExecutionTimeoutProperty = Framework.getProperty((String)TASK_EXECUTION_TIMEOUT_PROPERTY_KEY)) != null && !"".equals(taskExecutionTimeoutProperty)) {
            Long taskExecutionTimeout = Long.valueOf(taskExecutionTimeoutProperty);
            configuration.setTaskExecutionTimeout(taskExecutionTimeout.longValue());
        }
        if ((taskQueueTimeoutProperty = Framework.getProperty((String)TASK_QUEUE_TIMEOUT_PROPERTY_KEY)) != null && !"".equals(taskQueueTimeoutProperty)) {
            Long taskQueueTimeout = Long.valueOf(taskQueueTimeoutProperty);
            configuration.setTaskQueueTimeout(taskQueueTimeout.longValue());
        }
        if ((templateProfileDir = Framework.getProperty((String)TEMPLATE_PROFILE_DIR_PROPERTY_KEY)) != null && !"".equals(templateProfileDir)) {
            File templateDirectory = new File(templateProfileDir);
            if (!templateDirectory.exists()) {
                try {
                    FileUtils.forceMkdir((File)templateDirectory);
                }
                catch (IOException e) {
                    throw new RuntimeException("I/O Error: could not create JOD templateDirectory");
                }
            }
            configuration.setTemplateProfileDir(templateDirectory);
        }
        if ((pipeNames = this.descriptor.getPipeNames()) != null && pipeNames.length != 0) {
            configuration.setPipeNames(pipeNames);
        }
        if ((portNumbers = this.descriptor.getPortNumbers()) != null && portNumbers.length != 0) {
            configuration.setPortNumbers(portNumbers);
        }
        try {
            officeManager = configuration.buildOfficeManager();
            officeManager.start();
            this.started = true;
            log.debug((Object)"Starting ooo manager.");
        }
        catch (Exception e) {
            Throwable t = this.unwrapException(e);
            log.warn((Object)("OpenOffice was not found, JOD Converter won't be available: " + t.getMessage()));
        }
    }

    public Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ServletException) {
            cause = ((ServletException)t).getRootCause();
        } else if (t instanceof ClientException) {
            cause = t.getCause();
        } else if (t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return this.unwrapException(cause);
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            try {
                this.startOOoManager();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not start OOoManager.", e);
            }
        }
    }

    @Override
    public boolean isOOoManagerStarted() {
        return this.started;
    }
}

