/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.AuditRuntimeException;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;

public class LogEntryProvider {
    private static final Log log = LogFactory.getLog(LogEntryProvider.class);
    protected final EntityManager em;

    private LogEntryProvider(EntityManager em) {
        this.em = em;
    }

    public static LogEntryProvider createProvider(EntityManager em) {
        return new LogEntryProvider(em);
    }

    protected void doPersist(LogEntry entry) {
        this.em.persist((Object)entry);
    }

    protected List<LogEntry> doPublish(List<LogEntry> entries) {
        return entries;
    }

    protected LogEntry doPublish(LogEntry entry) {
        return entry;
    }

    public void addLogEntry(LogEntry entry) {
        this.doPersist(entry);
    }

    public void addLogEntries(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            this.doPersist(entry);
        }
    }

    public List<LogEntry> getLogEntriesFor(String uuid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() UUID=" + uuid));
        }
        Query query = this.em.createNamedQuery("LogEntry.findByDocument");
        query.setParameter("docUUID", (Object)uuid);
        return this.doPublish(query.getResultList());
    }

    @Deprecated
    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() UUID=" + uuid));
        }
        if (filterMap == null) {
            filterMap = new HashMap<String, FilterMapEntry>();
        }
        StringBuilder queryStr = new StringBuilder();
        queryStr.append(" FROM LogEntry log WHERE log.docUUID=:uuid ");
        Set<String> filterMapKeySet = filterMap.keySet();
        for (String currentKey : filterMapKeySet) {
            FilterMapEntry currentFilterMapEntry = filterMap.get(currentKey);
            String currentOperator = currentFilterMapEntry.getOperator();
            String currentQueryParameterName = currentFilterMapEntry.getQueryParameterName();
            String currentColumnName = currentFilterMapEntry.getColumnName();
            if ("LIKE".equals(currentOperator)) {
                queryStr.append(" AND log.").append(currentColumnName).append(" LIKE :").append(currentQueryParameterName).append(" ");
                continue;
            }
            queryStr.append(" AND log.").append(currentColumnName).append(currentOperator).append(":").append(currentQueryParameterName).append(" ");
        }
        if (doDefaultSort) {
            queryStr.append(" ORDER BY log.eventDate DESC");
        }
        Query query = this.em.createQuery(queryStr.toString());
        query.setParameter("uuid", (Object)uuid);
        for (String currentKey : filterMapKeySet) {
            FilterMapEntry currentFilterMapEntry = filterMap.get(currentKey);
            String currentOperator = currentFilterMapEntry.getOperator();
            String currentQueryParameterName = currentFilterMapEntry.getQueryParameterName();
            Object currentObject = currentFilterMapEntry.getObject();
            if ("LIKE".equals(currentOperator)) {
                query.setParameter(currentQueryParameterName, (Object)("%" + currentObject + "%"));
                continue;
            }
            query.setParameter(currentQueryParameterName, currentObject);
        }
        return this.doPublish(query.getResultList());
    }

    public LogEntry getLogEntryByID(long id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() logID=" + id));
        }
        return this.doPublish((LogEntry)this.em.find(LogEntry.class, (Object)id));
    }

    public List<LogEntry> nativeQueryLogs(String whereClause, int pageNb, int pageSize) {
        Query query = this.em.createQuery("from LogEntry log where " + whereClause);
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        }
        query.setMaxResults(pageSize);
        return this.doPublish(query.getResultList());
    }

    public List<?> nativeQuery(String queryString, int pageNb, int pageSize) {
        Query query = this.em.createQuery(queryString);
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        }
        query.setMaxResults(pageSize);
        return query.getResultList();
    }

    public List<LogEntry> queryLogs(String[] eventIds, String dateRange) {
        Date limit;
        try {
            limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
        }
        catch (AuditQueryException aqe) {
            throw new AuditRuntimeException("Wrong date range query. Query was " + dateRange, (Throwable)aqe);
        }
        String queryStr = "";
        if (eventIds == null || eventIds.length == 0) {
            queryStr = "from LogEntry log where log.eventDate >= :limit ORDER BY log.eventDate DESC";
        } else {
            String inClause = "(";
            for (String eventId : eventIds) {
                inClause = inClause + "'" + eventId + "',";
            }
            inClause = inClause.substring(0, inClause.length() - 1);
            inClause = inClause + ")";
            queryStr = "from LogEntry log where log.eventId in " + inClause + " AND log.eventDate >= :limit" + " ORDER BY log.eventDate DESC";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("queryLogs() =" + queryStr));
        }
        Query query = this.em.createQuery(queryStr);
        query.setParameter("limit", (Object)limit);
        return this.doPublish(query.getResultList());
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) throws AuditException {
        Date limit = null;
        try {
            limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
        }
        catch (AuditQueryException aqe) {
            throw new AuditException("Wrong date range query. Query was " + dateRange, (Throwable)aqe);
        }
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        String inClause;
        if (eventIds == null) {
            eventIds = new String[]{};
        }
        if (categories == null) {
            categories = new String[]{};
        }
        StringBuilder queryString = new StringBuilder();
        queryString.append("from LogEntry log where ");
        if (eventIds.length > 0) {
            inClause = "(";
            for (String eventId : eventIds) {
                inClause = inClause + "'" + eventId + "',";
            }
            inClause = inClause.substring(0, inClause.length() - 1);
            inClause = inClause + ")";
            queryString.append(" log.eventId IN ").append(inClause);
            queryString.append(" AND ");
        }
        if (categories.length > 0) {
            inClause = "(";
            for (String cat : categories) {
                inClause = inClause + "'" + cat + "',";
            }
            inClause = inClause.substring(0, inClause.length() - 1);
            inClause = inClause + ")";
            queryString.append(" log.category IN ").append(inClause);
            queryString.append(" AND ");
        }
        if (path != null && !"".equals(path.trim())) {
            queryString.append(" log.docPath LIKE '").append(path).append("%'");
            queryString.append(" AND ");
        }
        queryString.append(" log.eventDate >= :limit");
        queryString.append(" ORDER BY log.eventDate DESC");
        Query query = this.em.createQuery(queryString.toString());
        query.setParameter("limit", (Object)limit);
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        }
        query.setMaxResults(pageSize);
        return this.doPublish(query.getResultList());
    }

    public int removeEntries(String eventId, String pathPattern) {
        Query query = this.em.createNamedQuery("LogEntry.findByEventIdAndPath");
        query.setParameter("eventId", (Object)eventId);
        query.setParameter("pathPattern", (Object)(pathPattern + "%"));
        int count = 0;
        for (LogEntry entry : query.getResultList()) {
            this.em.remove((Object)entry);
            ++count;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removed " + count + " entries from " + pathPattern));
        }
        return count;
    }

    public Long countEventsById(String eventId) {
        Query query = this.em.createNamedQuery("LogEntry.countEventsById");
        query.setParameter("eventId", (Object)eventId);
        return (Long)query.getSingleResult();
    }

    public List<String> findEventIds() {
        Query query = this.em.createNamedQuery("LogEntry.findEventIds");
        return query.getResultList();
    }
}

