/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.DefaultNuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.runtime.api.Framework;

public class NuxeoSecurityExceptionHandler
extends DefaultNuxeoExceptionHandler {
    protected static final Log log = LogFactory.getLog(NuxeoSecurityExceptionHandler.class);
    private PluggableAuthenticationService service;

    @Override
    public void handleException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        Throwable unwrappedException = NuxeoSecurityExceptionHandler.unwrapException(t);
        if (!ExceptionHelper.isSecurityError(unwrappedException).booleanValue()) {
            super.handleException(request, response, t);
            return;
        }
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        Principal principal = request.getUserPrincipal();
        NuxeoPrincipal nuxeoPrincipal = null;
        if (principal instanceof NuxeoPrincipal && (nuxeoPrincipal = (NuxeoPrincipal)principal).isAnonymous()) {
            urlParameters.put("securityError", "true");
            urlParameters.put("forceAnonymousLogin", "true");
            if (request.getAttribute("requestedUrl") != null) {
                urlParameters.put("requestedUrl", (String)request.getAttribute("requestedUrl"));
            } else {
                urlParameters.put("requestedUrl", NuxeoAuthenticationFilter.getRequestedUrl(request));
            }
            if (!response.isCommitted()) {
                String baseURL = this.initAuthentificationService().getBaseURL((ServletRequest)request) + "logout";
                request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
                baseURL = URIUtils.addParametersToURIQuery((String)baseURL, urlParameters);
                response.sendRedirect(baseURL);
                FacesContext fContext = FacesContext.getCurrentInstance();
                if (fContext != null) {
                    fContext.responseComplete();
                } else {
                    log.error((Object)"Cannot set response complete: faces context is null");
                }
            } else {
                log.error((Object)"Cannot redirect to login page: response is already commited");
            }
            return;
        }
        super.handleException(request, response, t);
    }

    private PluggableAuthenticationService initAuthentificationService() throws ServletException {
        this.service = (PluggableAuthenticationService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService"));
        if (this.service == null) {
            log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            throw new ServletException("Can't initialize Nuxeo Pluggable Authentication Service");
        }
        return this.service;
    }
}

