/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsConstants;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.annotations.repository.service.GraphManagerEventListener;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.runtime.api.Framework;

public class DocumentVersionnedGraphManager
implements GraphManagerEventListener {
    private static final Log log = LogFactory.getLog(DocumentVersionnedGraphManager.class);
    private URNDocumentViewTranslator translator;

    @Override
    public void manage(Event event) {
        if (this.translator == null) {
            this.translator = new URNDocumentViewTranslator();
        }
        EventContext context = event.getContext();
        NuxeoPrincipal user = null;
        Principal principal = context.getPrincipal();
        if (!(principal instanceof NuxeoPrincipal)) {
            log.debug((Object)"Discading event on a non NuxeoPrincipal user");
            return;
        }
        user = (NuxeoPrincipal)principal;
        DocumentModel docModel = (DocumentModel)context.getArguments()[0];
        String docId = docModel.getId();
        String repo = docModel.getRepositoryName();
        if ("documentCreated".equals(event.getName())) {
            if (docModel.isVersion()) {
                String sourceId = docModel.getSourceId();
                this.copyGraphFor(repo, sourceId, docId, user);
            }
        } else if ("documentRemoved".equals(event.getName()) || "versionRemoved".equals(event.getName())) {
            this.removeGraphFor(repo, docId, user);
        } else if ("documentRestored".equals(event.getName())) {
            String versionUUID = (String)((Object)context.getProperty("RESTORED_VERSION_UUID"));
            this.restoreGraphFor(repo, versionUUID, docId, user);
        }
    }

    private void copyGraphFor(String repositoryName, String fromId, String toId, NuxeoPrincipal principal) {
        try {
            DocumentVersionnedGraphManager.copyGraphFor(this.translator.getNuxeoUrn(repositoryName, fromId), this.translator.getNuxeoUrn(repositoryName, toId), principal);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static void copyGraphFor(URI current, URI copied, NuxeoPrincipal user) throws Exception {
        ArrayList<StatementImpl> newStatements = new ArrayList<StatementImpl>();
        AnnotationsService service = (AnnotationsService)Framework.getService(AnnotationsService.class);
        List annotations = service.queryAnnotations(current, null, user);
        log.debug((Object)("Copying annotations graph from " + current + " to " + copied + " for " + annotations.size() + " annotations."));
        for (Annotation annotation : annotations) {
            List statements = annotation.getStatements();
            for (Statement statement : statements) {
                if (!statement.getPredicate().equals(AnnotationsConstants.a_annotates)) continue;
                Resource resource = (Resource)statement.getObject();
                if (!current.toString().equals(resource.getUri())) continue;
                StatementImpl newStatement = new StatementImpl((Node)statement.getSubject(), (Node)statement.getPredicate(), (Node)new ResourceImpl(copied.toString()));
                newStatements.add(newStatement);
            }
        }
        Graph graph = service.getAnnotationGraph();
        graph.add(newStatements);
    }

    private void removeGraphFor(String repositoryName, String id, NuxeoPrincipal principal) {
        try {
            DocumentVersionnedGraphManager.removeGraphFor(this.translator.getNuxeoUrn(repositoryName, id), principal);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static void removeGraphFor(URI uri, NuxeoPrincipal user) throws Exception {
        log.debug((Object)("Removing annotations graph for " + uri));
        AnnotationsService service = (AnnotationsService)Framework.getService(AnnotationsService.class);
        List annotations = service.queryAnnotations(uri, null, user);
        for (Annotation annotation : annotations) {
            service.deleteAnnotationFor(uri, annotation, user);
        }
    }

    private void restoreGraphFor(String repositoryName, String versionId, String docId, NuxeoPrincipal principal) {
        log.debug((Object)("Restoring annotations graph for docId:" + docId + " and versionId:" + versionId));
        try {
            DocumentVersionnedGraphManager.removeGraphFor(this.translator.getNuxeoUrn(repositoryName, docId), principal);
            this.copyGraphFor(repositoryName, versionId, docId, principal);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

